/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.en.ContourGenerator;
import com.sun.speech.freetts.en.us.CMUVoice;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;

public class FreeTTSContourGenerator
extends InternalModule {
    private UtteranceProcessor processor;

    public FreeTTSContourGenerator() {
        super("ContourGenerator", USEnglishDataTypes.FREETTS_DURATIONS, USEnglishDataTypes.FREETTS_CONTOUR, Locale.ENGLISH);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
        this.processor = new ContourGenerator(CMUVoice.class.getResource("f0_lr_terms.txt"), 170.0f, 34.0f);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processor.processUtterance(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }
}

