/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import marytts.cart.CART;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.features.FeatureVector;
import marytts.util.MaryUtils;
import marytts.util.data.MaryHeader;
import org.apache.log4j.Logger;

public class MaryCARTWriter {
    protected Logger logger = MaryUtils.getLogger(this.getClass().getName());

    public void dumpMaryCART(CART cart, String destFile) throws IOException {
        if (cart == null) {
            throw new NullPointerException("Cannot dump null CART");
        }
        if (destFile == null) {
            throw new NullPointerException("No destination file");
        }
        this.logger.debug("Dumping CART in MaryCART format to " + destFile + " ...");
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(destFile)));
        MaryHeader hdr = new MaryHeader(100);
        hdr.writeTo(out);
        Properties props = cart.getProperties();
        if (props == null) {
            out.writeShort(0);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            props.store(baos, null);
            byte[] propData = baos.toByteArray();
            out.writeShort(propData.length);
            out.write(propData);
        }
        cart.getFeatureDefinition().writeBinaryTo(out);
        this.dumpBinary(cart.getRootNode(), out);
        out.close();
        this.logger.debug(" ... done\n");
    }

    public void toTextOut(CART cart, PrintWriter pw) throws IOException {
        try {
            int[] id = new int[]{0, 0};
            this.setUniqueNodeId(cart.getRootNode(), id);
            pw.println("Num decision nodes= " + id[0] + "  Num leaf nodes= " + id[1]);
            this.printDecisionNodes(cart.getRootNode(), null, pw);
            pw.println("\n----------------\n");
            this.printLeafNodes(cart.getRootNode(), null, pw);
            pw.flush();
            pw.close();
        }
        catch (IOException ioe) {
            IOException newIOE = new IOException("Error dumping CART to standard output");
            newIOE.initCause(ioe);
            throw newIOE;
        }
    }

    private void setUniqueNodeId(Node node, int[] id) throws IOException {
        String leafstr = "";
        if (node.getNumberOfNodes() > 1) {
            assert (node instanceof DecisionNode);
            DecisionNode decNode = (DecisionNode)node;
            id[0] = id[0] - 1;
            decNode.setUniqueDecisionNodeId(id[0]);
            String strNode = "";
            int thisIdNode = id[0];
            for (int i = 0; i < decNode.getNumberOfDaugthers(); ++i) {
                this.setUniqueNodeId(decNode.getDaughter(i), id);
            }
        } else {
            assert (node instanceof LeafNode);
            LeafNode leaf = (LeafNode)node;
            if (leaf.isEmpty()) {
                leaf.setUniqueLeafId(0);
            } else {
                id[1] = id[1] + 1;
                leaf.setUniqueLeafId(id[1]);
            }
        }
    }

    private void dumpBinary(Node rootNode, DataOutput os) throws IOException {
        try {
            int[] id = new int[]{0, 0};
            this.setUniqueNodeId(rootNode, id);
            os.writeInt(Math.abs(id[0]));
            this.printDecisionNodes(rootNode, os, null);
            os.writeInt(id[1]);
            this.printLeafNodes(rootNode, (DataOutputStream)os, null);
        }
        catch (IOException ioe) {
            IOException newIOE = new IOException("Error dumping CART to output stream");
            newIOE.initCause(ioe);
            throw newIOE;
        }
    }

    private void printDecisionNodes(Node node, DataOutput out, PrintWriter pw) throws IOException {
        int i;
        if (!(node instanceof DecisionNode)) {
            return;
        }
        DecisionNode decNode = (DecisionNode)node;
        int id = decNode.getUniqueDecisionNodeId();
        String nodeDefinition = decNode.getNodeDefinition();
        int featureIndex = decNode.getFeatureIndex();
        DecisionNode.Type nodeType = decNode.getDecisionNodeType();
        if (out != null) {
            out.writeInt(featureIndex);
            out.writeInt(nodeType.ordinal());
            switch (nodeType) {
                case BinaryByteDecisionNode: {
                    out.writeInt(((DecisionNode.BinaryByteDecisionNode)decNode).getCriterionValueAsByte());
                    assert (decNode.getNumberOfDaugthers() == 2);
                    break;
                }
                case BinaryShortDecisionNode: {
                    out.writeInt(((DecisionNode.BinaryShortDecisionNode)decNode).getCriterionValueAsShort());
                    assert (decNode.getNumberOfDaugthers() == 2);
                    break;
                }
                case BinaryFloatDecisionNode: {
                    out.writeFloat(((DecisionNode.BinaryFloatDecisionNode)decNode).getCriterionValueAsFloat());
                    assert (decNode.getNumberOfDaugthers() == 2);
                    break;
                }
                case ByteDecisionNode: 
                case ShortDecisionNode: {
                    out.writeInt(decNode.getNumberOfDaugthers());
                }
            }
            int n = decNode.getNumberOfDaugthers();
            for (i = 0; i < n; ++i) {
                Node daughter = decNode.getDaughter(i);
                if (daughter instanceof DecisionNode) {
                    out.writeInt(((DecisionNode)daughter).getUniqueDecisionNodeId());
                    continue;
                }
                assert (daughter instanceof LeafNode);
                out.writeInt(((LeafNode)daughter).getUniqueLeafId());
            }
        }
        if (pw != null) {
            StringBuilder strNode = new StringBuilder(id + " " + nodeDefinition);
            int n = decNode.getNumberOfDaugthers();
            for (int i2 = 0; i2 < n; ++i2) {
                strNode.append(" ");
                Node daughter = decNode.getDaughter(i2);
                if (daughter instanceof DecisionNode) {
                    strNode.append(((DecisionNode)daughter).getUniqueDecisionNodeId());
                    continue;
                }
                assert (daughter instanceof LeafNode);
                strNode.append("id").append(((LeafNode)daughter).getUniqueLeafId());
            }
            pw.println(strNode.toString());
        }
        for (i = 0; i < ((DecisionNode)node).getNumberOfDaugthers(); ++i) {
            if (((DecisionNode)node).getDaughter(i).getNumberOfNodes() <= 1) continue;
            this.printDecisionNodes(((DecisionNode)node).getDaughter(i), out, pw);
        }
    }

    private void printLeafNodes(Node node, DataOutput out, PrintWriter pw) throws IOException {
        if (node.getNumberOfNodes() > 1) {
            assert (node instanceof DecisionNode);
            DecisionNode decNode = (DecisionNode)node;
            for (int i = 0; i < decNode.getNumberOfDaugthers(); ++i) {
                Node nextNode = decNode.getDaughter(i);
                this.printLeafNodes(nextNode, out, pw);
            }
        } else {
            assert (node instanceof LeafNode);
            LeafNode leaf = (LeafNode)node;
            if (leaf.getUniqueLeafId() == 0) {
                return;
            }
            LeafNode.LeafType leafType = leaf.getLeafNodeType();
            if (leafType == LeafNode.LeafType.FeatureVectorLeafNode) {
                leafType = LeafNode.LeafType.IntArrayLeafNode;
            }
            if (out != null) {
                out.writeInt(leafType.ordinal());
            }
            if (pw != null) {
                pw.print("id" + leaf.getUniqueLeafId() + " " + (Object)((Object)leafType));
            }
            switch (leaf.getLeafNodeType()) {
                case IntArrayLeafNode: {
                    int[] data = ((LeafNode.IntArrayLeafNode)leaf).getIntData();
                    if (out != null) {
                        out.writeInt(data.length);
                    }
                    if (pw != null) {
                        pw.print(" " + data.length);
                    }
                    for (int i = 0; i < data.length; ++i) {
                        if (out != null) {
                            out.writeInt(data[i]);
                        }
                        if (pw == null) continue;
                        pw.print(" " + data[i]);
                    }
                    break;
                }
                case FloatLeafNode: {
                    float stddev = ((LeafNode.FloatLeafNode)leaf).getStDeviation();
                    float mean = ((LeafNode.FloatLeafNode)leaf).getMean();
                    if (out != null) {
                        out.writeFloat(stddev);
                        out.writeFloat(mean);
                    }
                    if (pw == null) break;
                    pw.print(" 1 " + stddev + " " + mean);
                    break;
                }
                case IntAndFloatArrayLeafNode: 
                case StringAndFloatLeafNode: {
                    int[] data1 = ((LeafNode.IntAndFloatArrayLeafNode)leaf).getIntData();
                    float[] floats = ((LeafNode.IntAndFloatArrayLeafNode)leaf).getFloatData();
                    if (out != null) {
                        out.writeInt(data1.length);
                    }
                    if (pw != null) {
                        pw.print(" " + data1.length);
                    }
                    for (int i = 0; i < data1.length; ++i) {
                        if (out != null) {
                            out.writeInt(data1[i]);
                            out.writeFloat(floats[i]);
                        }
                        if (pw == null) continue;
                        pw.print(" " + data1[i] + " " + floats[i]);
                    }
                    break;
                }
                case FeatureVectorLeafNode: {
                    FeatureVector[] fv = ((LeafNode.FeatureVectorLeafNode)leaf).getFeatureVectors();
                    if (out != null) {
                        out.writeInt(fv.length);
                    }
                    if (pw != null) {
                        pw.print(" " + fv.length);
                    }
                    for (int i = 0; i < fv.length; ++i) {
                        if (out != null) {
                            out.writeInt(fv[i].getUnitIndex());
                        }
                        if (pw == null) continue;
                        pw.print(" " + fv[i].getUnitIndex());
                    }
                    break;
                }
                case PdfLeafNode: {
                    throw new IllegalArgumentException("Writing of pdf leaf nodes not yet implemented");
                }
            }
            if (pw != null) {
                pw.println();
            }
        }
    }
}

