/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.impose;

import marytts.cart.impose.FeatureArrayIndexer;
import marytts.features.FeatureVector;

public class MaryNode {
    protected int featureIndex = -1;
    protected int from = 0;
    protected int to = 0;
    private MaryNode[] kids = null;

    public MaryNode(int setFrom, int setTo) {
        this.from = setFrom;
        this.to = setTo;
        this.kids = null;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getNumChildren() {
        return this.kids.length;
    }

    public MaryNode[] getChildren() {
        return this.kids;
    }

    public void setFeatureIndex(int i) {
        this.featureIndex = i;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    public void split(int numKids) {
        this.kids = new MaryNode[numKids];
    }

    public void setChild(int i, MaryNode n) {
        this.kids[i] = n;
    }

    public MaryNode getChild(int i) {
        return this.kids[i];
    }

    public boolean isNode() {
        return this.kids != null;
    }

    public boolean isLeaf() {
        return this.kids == null;
    }

    public void toStandardOut(FeatureArrayIndexer ffi, int level) {
        String blanks = "";
        for (int i = 0; i < level; ++i) {
            blanks = blanks + "   ";
        }
        if (this.kids != null) {
            String featureName = ffi.getFeatureDefinition().getFeatureName(this.featureIndex);
            System.out.println("Node " + featureName + " has " + (this.to - this.from) + " units divided into " + this.kids.length + " branches.");
            for (int i = 0; i < this.kids.length; ++i) {
                if (this.kids[i] != null) {
                    System.out.print(blanks + "Branch " + i + "/" + this.kids.length + " ( " + ffi.getFeatureDefinition().getFeatureName(this.featureIndex) + " is " + ffi.getFeatureDefinition().getFeatureValueAsString(this.featureIndex, i) + " )" + " -> ");
                    this.kids[i].toStandardOut(ffi, level + 1);
                    continue;
                }
                System.out.println(blanks + "Branch " + i + "/" + this.kids.length + " ( " + ffi.getFeatureDefinition().getFeatureName(this.featureIndex) + " is " + ffi.getFeatureDefinition().getFeatureValueAsString(this.featureIndex, i) + " )" + " -> DEAD BRANCH (0 units)");
            }
        } else {
            FeatureVector[] fv = ffi.getFeatureVectors(this.from, this.to);
            System.out.print("LEAF has " + (this.to - this.from) + " units : ");
            for (int i = 0; i < fv.length; ++i) {
                System.out.print(fv[i].getUnitIndex() + " ");
            }
            System.out.print("\n");
        }
    }
}

