/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart;

import java.util.Properties;
import marytts.cart.DecisionNode;
import marytts.cart.DirectedGraph;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.select.Target;

public class CART
extends DirectedGraph {
    public CART() {
    }

    public CART(FeatureDefinition featDef) {
        super(featDef);
    }

    public CART(Node rootNode, FeatureDefinition featDef) {
        super(rootNode, featDef);
    }

    public CART(Node rootNode, FeatureDefinition featDef, Properties properties) {
        super(rootNode, featDef, properties);
    }

    public Node interpretToNode(Target target, int minNumberOfData) {
        return this.interpretToNode(target.getFeatureVector(), minNumberOfData);
    }

    public Node interpretToNode(FeatureVector featureVector, int minNumberOfData) {
        Node currentNode = this.rootNode;
        Node prevNode = null;
        while (currentNode != null && currentNode.getNumberOfData() > minNumberOfData && !(currentNode instanceof LeafNode)) {
            prevNode = currentNode;
            currentNode = ((DecisionNode)currentNode).getNextNode(featureVector);
        }
        if (currentNode == null || currentNode.getNumberOfData() < minNumberOfData && prevNode != null) {
            currentNode = prevNode;
        }
        assert (currentNode.getNumberOfData() >= minNumberOfData || currentNode == this.rootNode);
        assert (minNumberOfData > 0 || currentNode instanceof LeafNode);
        return currentNode;
    }

    public Object interpret(Target target, int minNumberOfData) {
        Object result = this.interpretToNode(target, minNumberOfData).getAllData();
        return result;
    }

    public static Node replaceLeafByCart(CART cart, LeafNode leaf) {
        DecisionNode mother = (DecisionNode)leaf.getMother();
        Node newNode = cart.getRootNode();
        mother.replaceDaughter(newNode, leaf.getNodeIndex());
        newNode.setIsRoot(false);
        return newNode;
    }
}

