/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer.output;

import de.dfki.lt.tools.tokenizer.output.Token;
import java.util.ArrayList;
import java.util.List;

public class TextUnit {
    private int startIndex;
    private int endIndex;
    private List<Token> tokens;

    public TextUnit() {
        this.setStartIndex(0);
        this.setEndIndex(0);
        this.setTokens(new ArrayList<Token>());
    }

    public TextUnit(List<Token> someTokens) {
        this.setTokens(someTokens);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int aStartIndex) {
        this.startIndex = aStartIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int anEndIndex) {
        this.endIndex = anEndIndex;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<Token> someTokens) {
        this.tokens = someTokens;
        if (someTokens.size() > 0) {
            this.setStartIndex(someTokens.get(0).getStartIndex());
            this.setEndIndex(someTokens.get(someTokens.size() - 1).getEndIndex());
        } else {
            this.setStartIndex(0);
            this.setEndIndex(0);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        String newline = System.getProperty("line.separator");
        result.append("  Text Unit Start: ").append(this.getStartIndex()).append(newline).append("  Text Unit End: ").append(this.getEndIndex()).append(newline);
        for (Token oneToken : this.getTokens()) {
            result.append(oneToken.toString());
        }
        return result.toString();
    }
}

