/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.en;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;

public class PauseGenerator
implements UtteranceProcessor {
    private static final PathExtractor segmentPath = new PathExtractorImpl("R:SylStructure.daughtern.daughtern.R:Segment", false);
    private static final PathExtractor puncPath = new PathExtractorImpl("R:Token.parent.punc", true);

    public void processUtterance(Utterance utterance) throws ProcessException {
        String silence = utterance.getVoice().getFeatures().getString("silence");
        Item phraseHead = utterance.getRelation("Phrase").getHead();
        if (phraseHead == null) {
            return;
        }
        Relation segment = utterance.getRelation("Segment");
        Item s = segment.getHead();
        s = s == null ? segment.appendItem(null) : s.prependItem(null);
        s.getFeatures().setString("name", silence);
        Item phrase = phraseHead;
        while (phrase != null) {
            Item word = phrase.getLastDaughter();
            while (word != null) {
                Item seg = segmentPath.findItem(word);
                if (seg != null) {
                    Item pause = seg.appendItem(null);
                    pause.getFeatures().setString("name", silence);
                    break;
                }
                word = word.getPrevious();
            }
            phrase = phrase.getNext();
        }
    }

    public String toString() {
        return "PauseGenerator";
    }
}

