/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.diphone;

import com.sun.speech.freetts.diphone.Diphone;
import com.sun.speech.freetts.relp.Sample;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class AliasDiphone
extends Diphone {
    private String originalName;
    private Diphone original;

    public AliasDiphone(String name, String originalName) {
        super(name);
        this.originalName = originalName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalDiphone(Diphone original) {
        if (!this.originalName.equals(original.getName())) {
            throw new IllegalArgumentException("The diphone to register (" + original.getName() + ") does not match the original name (" + this.originalName + ")");
        }
        this.original = original;
    }

    public Sample[] getSamples() {
        return this.original.getSamples();
    }

    public Sample getSamples(int which) {
        return this.original.getSamples(which);
    }

    public int getMidPoint() {
        return this.original.getMidPoint();
    }

    public int getPbPositionMillis() {
        return this.original.getPbPositionMillis();
    }

    public Sample nearestSample(float uIndex, int unitPart) {
        return this.original.nearestSample(uIndex, unitPart);
    }

    public int getUnitSize(int unitPart) {
        return this.original.getUnitSize(unitPart);
    }

    public void dump() {
        System.out.println("AliasDiphone: " + this.getName() + " aliased to " + this.original.getName());
    }

    public void dumpBinary(ByteBuffer bb) throws IOException {
        int i;
        char[] nameArray = (this.getName() + "        ").toCharArray();
        char[] origNameArray = (this.original.getName() + "        ").toCharArray();
        bb.putInt(195800832);
        for (i = 0; i < 8; ++i) {
            bb.putChar(nameArray[i]);
        }
        for (i = 0; i < 8; ++i) {
            bb.putChar(origNameArray[i]);
        }
    }

    public void dumpBinary(DataOutputStream os) throws IOException {
        int i;
        char[] nameArray = (this.getName() + "        ").toCharArray();
        char[] origNameArray = (this.original.getName() + "        ").toCharArray();
        os.writeInt(195800832);
        for (i = 0; i < 8; ++i) {
            os.writeChar(nameArray[i]);
        }
        for (i = 0; i < 8; ++i) {
            os.writeChar(origNameArray[i]);
        }
    }

    boolean compare(Diphone other) {
        return this.original.compare(other);
    }
}

