/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.cart;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractor;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.PhoneDuration;
import com.sun.speech.freetts.PhoneDurations;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CART;

public class Durator
implements UtteranceProcessor {
    private float meanRate;
    protected CART cart;
    protected PhoneDurations durations;
    private static final PathExtractor DURATION_STRETCH_PATH = new PathExtractorImpl("R:SylStructure.parent.parent.R:Token.parent.local_duration_stretch", true);

    public Durator(CART cart, float meanRate, PhoneDurations durations) {
        this.cart = cart;
        this.meanRate = meanRate;
        this.durations = durations;
    }

    public void processUtterance(Utterance utterance) throws ProcessException {
        float durationStretch = utterance.getVoice().getDurationStretch();
        float end = 0.0f;
        float durStretch = this.meanRate / utterance.getVoice().getRate();
        for (Item segment = utterance.getRelation("Segment").getHead(); segment != null; segment = segment.getNext()) {
            float zdur = ((Float)this.cart.interpret(segment)).floatValue();
            PhoneDuration durStat = this.durations.getPhoneDuration(segment.getFeatures().getString("name"));
            Object tval = DURATION_STRETCH_PATH.findFeature(segment);
            float localDurationStretch = Float.parseFloat(tval.toString());
            localDurationStretch = (double)localDurationStretch == 0.0 ? durationStretch : (localDurationStretch *= durationStretch);
            float dur = localDurationStretch * (zdur * durStat.getStandardDeviation() + durStat.getMean());
            segment.getFeatures().setFloat("end", end += dur);
        }
    }

    public String toString() {
        return "CARTDurator";
    }
}

