/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Age;
import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.FeatureProcessor;
import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FeatureSetImpl;
import com.sun.speech.freetts.FreeTTSSpeakable;
import com.sun.speech.freetts.FreeTTSSpeakableImpl;
import com.sun.speech.freetts.Gender;
import com.sun.speech.freetts.OutputQueue;
import com.sun.speech.freetts.ProcessException;
import com.sun.speech.freetts.Token;
import com.sun.speech.freetts.Tokenizer;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.lexicon.Lexicon;
import com.sun.speech.freetts.relp.LPCResult;
import com.sun.speech.freetts.util.BulkTimer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class Voice
implements UtteranceProcessor,
Dumpable {
    public static final String DATABASE_NAME = "databaseName";
    private List utteranceProcessors;
    private Map featureProcessors;
    private FeatureSetImpl features;
    private boolean verbose = false;
    private boolean metrics = false;
    private boolean detailedMetrics = false;
    private boolean dumpUtterance = false;
    private boolean dumpRelations = false;
    private String runTitle = "unnamed run";
    private Lexicon lexicon = null;
    private AudioPlayer defaultAudioPlayer = null;
    private AudioPlayer audioPlayer = null;
    private UtteranceProcessor audioOutput;
    private OutputQueue outputQueue = null;
    private String waveDumpFile = null;
    private BulkTimer runTimer = new BulkTimer();
    private BulkTimer threadTimer = new BulkTimer();
    private boolean externalOutputQueue = false;
    private boolean externalAudioPlayer = false;
    private float nominalRate = 150.0f;
    private float pitch = 100.0f;
    private float range = 10.0f;
    private float pitchShift = 1.0f;
    private float volume = 0.8f;
    private float durationStretch = 1.0f;
    private boolean loaded = false;
    private String name = "default_name";
    private Age age = Age.DONT_CARE;
    private Gender gender = Gender.DONT_CARE;
    private String description = "default description";
    private Locale locale = Locale.getDefault();
    private String domain = "general";
    private String style = "standard";
    private String organization = "unknown";
    public static final String PROP_PREFIX = "com.sun.speech.freetts.voice.";
    public static final String FEATURE_SILENCE = "silence";
    public static final String FEATURE_JOIN_TYPE = "join_type";
    public static final String DEFAULT_AUDIO_PLAYER = "com.sun.speech.freetts.voice.defaultAudioPlayer";
    public static final String DEFAULT_AUDIO_PLAYER_DEFAULT = "com.sun.speech.freetts.audio.JavaStreamingAudioPlayer";

    public Voice() {
        this.utteranceProcessors = Collections.synchronizedList(new ArrayList());
        this.features = new FeatureSetImpl();
        this.featureProcessors = new HashMap();
        try {
            this.nominalRate = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.speakingRate", "150"));
            this.pitch = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.pitch", "100"));
            this.range = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.range", "10"));
            this.volume = Float.parseFloat(Utilities.getProperty("com.sun.speech.freetts.voice.volume", "1.0"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.outputQueue = null;
        this.audioPlayer = null;
        this.defaultAudioPlayer = null;
    }

    public Voice(String name, Gender gender, Age age, String description, Locale locale, String domain, String organization) {
        this();
        this.setName(name);
        this.setGender(gender);
        this.setAge(age);
        this.setDescription(description);
        this.setLocale(locale);
        this.setDomain(domain);
        this.setOrganization(organization);
    }

    public boolean speak(String text) {
        return this.speak(new FreeTTSSpeakableImpl(text));
    }

    public boolean speak(Document doc) {
        return this.speak(new FreeTTSSpeakableImpl(doc));
    }

    public boolean speak(InputStream inputStream) {
        return this.speak(new FreeTTSSpeakableImpl(inputStream));
    }

    public boolean speak(FreeTTSSpeakable speakable) {
        this.log("speak(FreeTTSSpeakable) called");
        boolean ok = true;
        boolean posted = false;
        this.getAudioPlayer().startFirstSampleTimer();
        try {
            long time = System.currentTimeMillis();
            Iterator i = this.tokenize(speakable);
            while (!speakable.isCompleted() && i.hasNext()) {
                try {
                    Utterance utterance = (Utterance)i.next();
                    if (utterance == null) continue;
                    this.processUtterance(utterance);
                    posted = true;
                }
                catch (ProcessException pe) {
                    ok = false;
                }
            }
            long newtime = System.currentTimeMillis() - time;
            System.out.println("Processing took " + newtime + " milliseconds");
            if (ok && posted) {
                this.runTimer.start("WaitAudio");
                ok = speakable.waitCompleted();
                this.runTimer.stop("WaitAudio");
            }
            this.log("speak(FreeTTSSpeakable) completed");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ok;
    }

    public void load() {
        this.allocate();
    }

    public void allocate() {
        if (this.isLoaded()) {
            return;
        }
        BulkTimer.LOAD.start();
        if (!this.lexicon.isLoaded()) {
            try {
                this.lexicon.load();
            }
            catch (IOException ioe) {
                this.error("Can't load voice " + ioe);
            }
        }
        try {
            this.audioOutput = this.getAudioOutput();
        }
        catch (IOException ioe) {
            this.error("Can't load audio output handler for voice " + ioe);
        }
        if (this.outputQueue == null) {
            this.outputQueue = Voice.createOutputThread();
        }
        try {
            this.loader();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.error("Can't load voice " + ioe);
        }
        BulkTimer.LOAD.stop();
        if (this.isMetrics()) {
            BulkTimer.LOAD.show("loading " + this.toString() + " for " + this.getRunTitle());
        }
        this.setLoaded(true);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void processUtterance(Utterance u) throws ProcessException {
        if (this.utteranceProcessors == null) {
            return;
        }
        if (u == null) {
            throw new ProcessException("Utterance is null.");
        }
        this.runTimer.start("processing");
        UtteranceProcessor[] processors = new UtteranceProcessor[this.utteranceProcessors.size()];
        processors = this.utteranceProcessors.toArray(processors);
        this.log("Processing Utterance: " + u.getString("input_text"));
        try {
            for (int i = 0; i < processors.length && !u.getSpeakable().isCompleted(); ++i) {
                this.runProcessor(processors[i], u, this.runTimer);
            }
            if (!u.getSpeakable().isCompleted()) {
                if (this.outputQueue == null) {
                    this.log("To AudioOutput");
                    this.outputUtterance(u, this.runTimer);
                } else {
                    this.runTimer.start("..post");
                    this.outputQueue.post(u);
                    this.runTimer.stop("..post");
                }
            }
        }
        catch (ProcessException pe) {
            System.err.println("Processing Utterance: " + pe);
        }
        catch (Exception e) {
            System.err.println("Trouble while processing utterance " + e);
            e.printStackTrace();
            u.getSpeakable().cancelled();
        }
        this.log("Done Processing Utterance: " + u.getString("input_text"));
        this.runTimer.stop("processing");
        if (this.dumpUtterance) {
            u.dump("Utterance");
        }
        if (this.dumpRelations) {
            u.dumpRelations("Utterance");
        }
        this.dumpASCII(u);
    }

    private void dumpASCII(Utterance utterance) {
        if (this.waveDumpFile != null) {
            LPCResult lpcResult = (LPCResult)utterance.getObject("target_lpcres");
            try {
                if (this.waveDumpFile.equals("-")) {
                    lpcResult.dumpASCII();
                } else {
                    lpcResult.dumpASCII(this.waveDumpFile);
                }
            }
            catch (IOException ioe) {
                this.error("Can't dump file to " + this.waveDumpFile + " " + ioe);
            }
        }
    }

    public static OutputQueue createOutputThread() {
        final OutputQueue queue = new OutputQueue();
        Thread t = new Thread(){

            public void run() {
                Utterance utterance = null;
                do {
                    if ((utterance = queue.pend()) == null) continue;
                    Voice voice = utterance.getVoice();
                    voice.log("OUT: " + utterance.getString("input_text"));
                    voice.outputUtterance(utterance, voice.threadTimer);
                } while (utterance != null);
            }
        };
        t.setDaemon(true);
        t.start();
        return queue;
    }

    private boolean outputUtterance(Utterance utterance, BulkTimer timer) {
        boolean ok = true;
        FreeTTSSpeakable speakable = utterance.getSpeakable();
        if (!speakable.isCompleted()) {
            if (utterance.isFirst()) {
                this.getAudioPlayer().reset();
                speakable.started();
                this.log(" --- started ---");
            }
            try {
                if (!speakable.isCompleted()) {
                    this.runProcessor(this.audioOutput, utterance, timer);
                } else {
                    ok = false;
                }
            }
            catch (ProcessException pe) {
                ok = false;
            }
            if (ok && utterance.isLast()) {
                this.getAudioPlayer().drain();
                speakable.completed();
                this.log(" --- completed ---");
            } else if (!ok) {
                speakable.cancelled();
                this.log(" --- cancelled ---");
            } else {
                this.log(" --- not last: " + speakable.getText() + " --- ");
            }
            this.log("Calling speakable.completed() on " + speakable.getText());
        } else {
            ok = false;
            this.log("STRANGE: speakable already completed: " + speakable.getText());
        }
        return ok;
    }

    private void runProcessor(UtteranceProcessor processor, Utterance utterance, BulkTimer timer) throws ProcessException {
        if (processor != null) {
            long time = System.currentTimeMillis();
            String processorName = ".." + processor.toString();
            this.log("   Running " + processorName);
            timer.start(processorName);
            processor.processUtterance(utterance);
            timer.stop(processorName);
            long newtime = System.currentTimeMillis() - time;
            System.out.println(processor.toString() + ": Processing took " + newtime + " milliseconds");
        }
    }

    public abstract Tokenizer getTokenizer();

    public List getUtteranceProcessors() {
        return this.utteranceProcessors;
    }

    public FeatureSet getFeatures() {
        return this.features;
    }

    public void startBatch() {
        this.runTimer.setVerbose(this.detailedMetrics);
        this.runTimer.start();
    }

    public void endBatch() {
        this.runTimer.stop();
        if (this.metrics) {
            this.runTimer.show(this.getRunTitle() + " run");
            this.threadTimer.show(this.getRunTitle() + " thread");
            this.getAudioPlayer().showMetrics();
            long totalMemory = Runtime.getRuntime().totalMemory();
            System.out.println("Memory Use    : " + (totalMemory - Runtime.getRuntime().freeMemory()) / 1024L + "k  of " + totalMemory / 1024L + "k");
        }
    }

    public void setOutputQueue(OutputQueue queue) {
        this.externalOutputQueue = true;
        this.outputQueue = queue;
    }

    public OutputQueue getOutputQueue() {
        return this.outputQueue;
    }

    protected abstract void loader() throws IOException;

    private Iterator tokenize(FreeTTSSpeakable speakable) {
        return new FreeTTSSpeakableTokenizer(speakable).iterator();
    }

    private String documentToString(Document dom) {
        StringBuffer buf = new StringBuffer();
        this.linearize(dom, buf);
        return buf.toString();
    }

    private void linearize(Node n, StringBuffer buf) {
        StringBuffer endText = this.processNode(n, buf);
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.linearize(child, buf);
        }
        if (endText != null) {
            buf.append(endText);
        }
    }

    protected StringBuffer processNode(Node n, StringBuffer buf) {
        StringBuffer endText = null;
        short type = n.getNodeType();
        switch (type) {
            case 2: {
                break;
            }
            case 9: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                buf.append(((Text)n).getData());
                break;
            }
            case 7: {
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 11: {
                break;
            }
        }
        return endText;
    }

    public void dump(PrintWriter output, int pad, String title) {
        Utilities.dump(output, pad, title);
        this.features.dump(output, pad + 4, title + " Features");
        this.dumpProcessors(output, pad + 4, title + " Processors");
    }

    public void dumpProcessors(PrintWriter output, int pad, String title) {
        if (this.utteranceProcessors == null) {
            return;
        }
        UtteranceProcessor[] processors = new UtteranceProcessor[this.utteranceProcessors.size()];
        processors = this.utteranceProcessors.toArray(processors);
        Utilities.dump(output, pad, title);
        for (int i = 0; i < processors.length; ++i) {
            Utilities.dump(output, pad + 4, processors[i].toString());
        }
    }

    public FeatureProcessor getFeatureProcessor(String name) {
        return (FeatureProcessor)this.featureProcessors.get(name);
    }

    public void addFeatureProcessor(String name, FeatureProcessor fp) {
        this.featureProcessors.put(name, fp);
    }

    public void log(String message) {
        if (this.verbose) {
            System.out.println(this.toString() + ": " + message);
        }
    }

    public void warn(String message) {
        System.err.println("Warning: " + message);
    }

    public void error(String message) {
        System.err.println("Error: " + message);
        throw new Error(message);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        this.log("Verbose mode is " + verbose);
    }

    public boolean isMetrics() {
        return this.metrics;
    }

    public void setMetrics(boolean metrics) {
        this.metrics = metrics;
        this.log("Metrics mode is " + metrics);
    }

    public boolean isDetailedMetrics() {
        return this.detailedMetrics;
    }

    public void setDetailedMetrics(boolean detailedMetrics) {
        this.detailedMetrics = detailedMetrics;
        this.log("DetailedMetrics mode is " + detailedMetrics);
    }

    public boolean isDumpUtterance() {
        return this.dumpUtterance;
    }

    public void setDumpUtterance(boolean dumpUtterance) {
        this.dumpUtterance = dumpUtterance;
        this.log("DumpUtterance mode is " + dumpUtterance);
    }

    public boolean isDumpRelations() {
        return this.dumpRelations;
    }

    public void setDumpRelations(boolean dumpRelations) {
        this.dumpRelations = dumpRelations;
        this.log("DumpRelations mode is " + dumpRelations);
    }

    public void setRunTitle(String runTitle) {
        this.runTitle = runTitle;
    }

    public String getRunTitle() {
        return this.runTitle;
    }

    public String getPhoneFeature(String phone, String featureName) {
        return null;
    }

    public void deallocate() {
        this.setLoaded(false);
        if (!this.externalAudioPlayer && this.audioPlayer != null) {
            this.audioPlayer.close();
            this.audioPlayer = null;
        }
        if (!this.externalOutputQueue) {
            this.outputQueue.close();
        }
    }

    public void setPitch(float hertz) {
        this.pitch = hertz;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitchRange(float range) {
        this.range = range;
    }

    public float getPitchRange() {
        return this.range;
    }

    public void setPitchShift(float shift) {
        this.pitchShift = shift;
    }

    public float getPitchShift() {
        return this.pitchShift;
    }

    public void setDurationStretch(float stretch) {
        this.durationStretch = stretch;
    }

    public float getDurationStretch() {
        return this.durationStretch;
    }

    public void setRate(float wpm) {
        if (wpm > 0.0f && wpm < 1000.0f) {
            this.setDurationStretch(this.nominalRate / wpm);
        }
    }

    public float getRate() {
        return this.durationStretch * this.nominalRate;
    }

    public void setVolume(float vol) {
        this.volume = vol;
    }

    public float getVolume() {
        return this.volume;
    }

    public Lexicon getLexicon() {
        return this.lexicon;
    }

    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
    }

    public void setWaveDumpFile(String waveDumpFile) {
        this.waveDumpFile = waveDumpFile;
    }

    public String getWaveDumpFile() {
        return this.waveDumpFile;
    }

    private void traceStack() {
        new Throwable().printStackTrace();
    }

    public void setAudioPlayer(AudioPlayer player) {
        this.audioPlayer = player;
        this.externalAudioPlayer = true;
    }

    public AudioPlayer getDefaultAudioPlayer() throws InstantiationException {
        if (this.defaultAudioPlayer != null) {
            return this.defaultAudioPlayer;
        }
        String className = Utilities.getProperty(DEFAULT_AUDIO_PLAYER, DEFAULT_AUDIO_PLAYER_DEFAULT);
        try {
            Class<?> cls = Class.forName(className);
            this.defaultAudioPlayer = (AudioPlayer)cls.newInstance();
            return this.defaultAudioPlayer;
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Can't find class " + className);
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Can't find class " + className);
        }
        catch (ClassCastException e) {
            throw new InstantiationException(className + " cannot be cast " + "to AudioPlayer");
        }
    }

    public AudioPlayer getAudioPlayer() {
        if (this.audioPlayer == null) {
            try {
                this.audioPlayer = this.getDefaultAudioPlayer();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return this.audioPlayer;
    }

    protected URL getResource(String resource) {
        return this.getClass().getResource(resource);
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    protected void setGender(Gender gender) {
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    protected void setAge(Age age) {
        this.age = age;
    }

    public Age getAge() {
        return this.age;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    protected void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganization() {
        return this.organization;
    }

    protected abstract UtteranceProcessor getAudioOutput() throws IOException;

    private class FreeTTSSpeakableTokenizer {
        FreeTTSSpeakable speakable;
        Tokenizer tok;

        public FreeTTSSpeakableTokenizer(FreeTTSSpeakable speakable) {
            this.tok = Voice.this.getTokenizer();
            this.speakable = speakable;
            if (speakable.isPlainText()) {
                this.tok.setInputText(speakable.getText());
            } else if (speakable.isStream()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(speakable.getInputStream()));
                this.tok.setInputReader(reader);
            } else if (speakable.isDocument()) {
                this.tok.setInputText(Voice.this.documentToString(speakable.getDocument()));
            }
        }

        public Iterator iterator() {
            return new Iterator(this){
                boolean first;
                Token savedToken;
                private final /* synthetic */ FreeTTSSpeakableTokenizer this$1;
                {
                    this.this$1 = this$1;
                    this.first = true;
                    this.savedToken = null;
                }

                public boolean hasNext() {
                    return this.savedToken != null || this.this$1.tok.hasMoreTokens();
                }

                public Object next() {
                    ArrayList<Token> tokenList = new ArrayList<Token>();
                    Utterance utterance = null;
                    if (this.savedToken != null) {
                        tokenList.add(this.savedToken);
                        this.savedToken = null;
                    }
                    while (this.this$1.tok.hasMoreTokens()) {
                        Token token = this.this$1.tok.getNextToken();
                        if (token.getWord().length() == 0 || tokenList.size() > 500 || this.this$1.tok.isBreak()) {
                            this.savedToken = token;
                            break;
                        }
                        tokenList.add(token);
                    }
                    utterance = new Utterance(FreeTTSSpeakableTokenizer.access$300(this.this$1), tokenList);
                    utterance.setSpeakable(this.this$1.speakable);
                    utterance.setFirst(this.first);
                    this.first = false;
                    boolean isLast = !this.this$1.tok.hasMoreTokens() && (this.savedToken == null || this.savedToken.getWord().length() == 0);
                    utterance.setLast(isLast);
                    return utterance;
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        static /* synthetic */ Voice access$300(FreeTTSSpeakableTokenizer x0) {
            return x0.Voice.this;
        }
    }
}

