/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.Dumpable;
import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.util.Utilities;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FeatureSetImpl
implements FeatureSet {
    private Map featureMap = new LinkedHashMap();
    static DecimalFormat formatter;

    public boolean isPresent(String name) {
        return this.featureMap.containsKey(name);
    }

    public void remove(String name) {
        this.featureMap.remove(name);
    }

    public String getString(String name) {
        return (String)this.getObject(name);
    }

    public int getInt(String name) {
        return (Integer)this.getObject(name);
    }

    public float getFloat(String name) {
        return ((Float)this.getObject(name)).floatValue();
    }

    public Object getObject(String name) {
        return this.featureMap.get(name);
    }

    public void setInt(String name, int value) {
        this.setObject(name, new Integer(value));
    }

    public void setFloat(String name, float value) {
        this.setObject(name, new Float(value));
    }

    public void setString(String name, String value) {
        this.setObject(name, value);
    }

    public void setObject(String name, Object value) {
        this.featureMap.put(name, value);
    }

    public void dump(PrintWriter output, int pad, String title) {
        this.dump(output, pad, title, false);
    }

    public void dump(PrintWriter output, int pad, String title, boolean showName) {
        ArrayList keys = new ArrayList(this.featureMap.keySet());
        if (formatter == null) {
            formatter = new DecimalFormat("########0.000000");
        }
        Collections.reverse(keys);
        Utilities.dump(output, pad, title);
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!showName && key.equals("name")) continue;
            Object value = this.getObject(key);
            if (value instanceof Dumpable) {
                Dumpable d = (Dumpable)value;
                d.dump(output, pad + 4, key);
                continue;
            }
            if (value instanceof Float) {
                Float fval = (Float)value;
                Utilities.dump(output, pad + 4, key + "=" + formatter.format(fval.floatValue()));
                continue;
            }
            Utilities.dump(output, pad + 4, key + "=" + value);
        }
    }
}

