/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.H;
import Jampack.JampackException;
import Jampack.Parameters;
import Jampack.Pivot;
import Jampack.Z;
import Jampack.Zchol;
import Jampack.Zltmat;
import Jampack.Zludpp;
import Jampack.Zmat;
import Jampack.Zpsdmat;
import Jampack.Zutmat;

public class Solve {
    public static Zmat aib(Zltmat L, Zmat B) throws JampackException {
        Z x = new Z();
        L.getProperties();
        B.getProperties();
        if (L.nr != L.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (L.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        Zmat X = new Zmat(B);
        for (int i = 0; i < L.nr; ++i) {
            for (int j = 0; j < B.nc; ++j) {
                for (int k = 0; k < i; ++k) {
                    X.re[i][j] = X.re[i][j] - L.re[i][k] * X.re[k][j] + L.im[i][k] * X.im[k][j];
                    X.im[i][j] = X.im[i][j] - L.im[i][k] * X.re[k][j] - L.re[i][k] * X.im[k][j];
                }
                if (L.re[i][i] == 0.0 && L.im[i][i] == 0.0) {
                    throw new JampackException("Zero diagonal in solving triangular system");
                }
                X.put0(i, j, x.Div(X.get0(i, j), L.get0(i, i)));
            }
        }
        return X;
    }

    public static Zmat ahib(Zltmat L, Zmat B) throws JampackException {
        Z x = new Z();
        L.getProperties();
        B.getProperties();
        if (L.nr != L.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (L.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        Zmat X = new Zmat(B);
        for (int i = L.nr - 1; i >= 0; --i) {
            if (L.re[i][i] == 0.0 && L.im[i][i] == 0.0) {
                throw new JampackException("Zero diagonal in solving triangular system");
            }
            for (int j = 0; j < B.nc; ++j) {
                X.put0(i, j, x.Div(X.get0(i, j), x.Conj(L.get0(i, i))));
                for (int k = 0; k < i; ++k) {
                    X.re[k][j] = X.re[k][j] - X.re[i][j] * L.re[i][k] - X.im[i][j] * L.im[i][k];
                    X.im[k][j] = X.im[k][j] + X.re[i][j] * L.im[i][k] - X.im[i][j] * L.re[i][k];
                }
            }
        }
        return X;
    }

    public static Zmat bai(Zmat B, Zltmat L) throws JampackException {
        Z x = new Z();
        L.getProperties();
        B.getProperties();
        if (L.nr != L.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (L.nr != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        return H.o(Solve.ahib(L, H.o(B)));
    }

    public static Zmat bahi(Zmat B, Zltmat L) throws JampackException {
        Z x = new Z();
        L.getProperties();
        B.getProperties();
        if (L.nr != L.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (L.nc != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        return H.o(Solve.aib(L, H.o(B)));
    }

    public static Zmat aib(Zutmat U, Zmat B) throws JampackException {
        Z x = new Z();
        U.getProperties();
        B.getProperties();
        if (U.nr != U.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (U.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        Zmat X = new Zmat(B);
        for (int i = U.nr - 1; i >= 0; --i) {
            for (int j = 0; j < B.nc; ++j) {
                for (int k = i + 1; k < U.nc; ++k) {
                    X.re[i][j] = X.re[i][j] - U.re[i][k] * X.re[k][j] + U.im[i][k] * X.im[k][j];
                    X.im[i][j] = X.im[i][j] - U.im[i][k] * X.re[k][j] - U.re[i][k] * X.im[k][j];
                }
                if (U.re[i][i] == 0.0 && U.im[i][i] == 0.0) {
                    throw new JampackException("Zero diagonal in solving riangular system");
                }
                X.put0(i, j, x.Div(X.get0(i, j), U.get0(i, i)));
            }
        }
        return X;
    }

    public static Zmat ahib(Zutmat U, Zmat B) throws JampackException {
        Z x = new Z();
        U.getProperties();
        B.getProperties();
        if (U.nr != U.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (U.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        Zmat X = new Zmat(B);
        for (int i = 0; i < U.nr; ++i) {
            if (U.re[i][i] == 0.0 && U.im[i][i] == 0.0) {
                throw new JampackException("Zero diagonal in solving lower triangular system");
            }
            for (int j = 0; j < B.nc; ++j) {
                X.put0(i, j, x.Div(X.get0(i, j), x.Conj(U.get0(i, i))));
                for (int k = i + 1; k < U.nr; ++k) {
                    X.re[k][j] = X.re[k][j] - X.re[i][j] * U.re[i][k] - X.im[i][j] * U.im[i][k];
                    X.im[k][j] = X.im[k][j] - X.im[i][j] * U.re[i][k] + X.re[i][j] * U.im[i][k];
                }
            }
        }
        return X;
    }

    public static Zmat bai(Zmat B, Zutmat U) throws JampackException {
        Z x = new Z();
        U.getProperties();
        B.getProperties();
        if (U.nr != U.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (U.nr != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        return H.o(Solve.ahib(U, H.o(B)));
    }

    public static Zmat bahi(Zmat B, Zutmat U) throws JampackException {
        Z x = new Z();
        U.getProperties();
        B.getProperties();
        if (U.nr != U.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (U.nc != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        return H.o(Solve.aib(U, H.o(B)));
    }

    public static Zmat aib(Zmat A, Zmat B) throws JampackException {
        Zludpp LU;
        A.getProperties();
        B.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (A.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        if (Parameters.History) {
            A.clean();
            if (A.LU == null) {
                A.LU = new Zludpp(A);
            }
            LU = A.LU;
        } else {
            LU = new Zludpp(A);
        }
        Zmat X = new Zmat(B);
        Pivot.row(X, LU.pvt);
        return Solve.aib(LU.U, Solve.aib(LU.L, X));
    }

    public static Zmat ahib(Zmat A, Zmat B) throws JampackException {
        Zludpp LU;
        A.getProperties();
        B.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (A.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        if (Parameters.History) {
            A.clean();
            if (A.LU == null) {
                A.LU = new Zludpp(A);
            }
            LU = A.LU;
        } else {
            LU = new Zludpp(A);
        }
        return Pivot.rowi(Solve.ahib(LU.L, Solve.ahib(LU.U, B)), LU.pvt);
    }

    public static Zmat bai(Zmat B, Zmat A) throws JampackException {
        A.getProperties();
        B.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (A.nr != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        if (Parameters.History) {
            A.clean();
            if (A.LU == null) {
                A.LU = new Zludpp(A);
            }
            Zludpp LU = A.LU;
        } else {
            Zludpp LU = new Zludpp(A);
        }
        return H.o(Solve.ahib(A, H.o(B)));
    }

    public static Zmat bahi(Zmat B, Zmat A) throws JampackException {
        A.getProperties();
        B.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (A.nr != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        if (Parameters.History) {
            A.clean();
            if (A.LU == null) {
                A.LU = new Zludpp(A);
            }
            Zludpp LU = A.LU;
        } else {
            Zludpp LU = new Zludpp(A);
        }
        return H.o(Solve.aib(A, H.o(B)));
    }

    public static Zmat aib(Zpsdmat A, Zmat B) throws JampackException {
        Zchol CHOL;
        A.getProperties();
        B.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (A.nr != B.nr) {
            throw new JampackException("Inconsistent dimensions.");
        }
        if (Parameters.History) {
            A.clean();
            if (A.CHOL == null) {
                A.CHOL = new Zchol(A);
            }
            CHOL = A.CHOL;
        } else {
            CHOL = new Zchol(A);
        }
        return Solve.aib(CHOL.R, Solve.ahib(CHOL.R, B));
    }

    public static Zmat bai(Zmat B, Zpsdmat A) throws JampackException {
        Zchol CHOL;
        A.getProperties();
        B.getProperties();
        if (A.nr != A.nc) {
            throw new JampackException("Rectangular matrix.");
        }
        if (A.nr != B.nc) {
            throw new JampackException("Inconsistent dimensions.");
        }
        if (Parameters.History) {
            A.clean();
            if (A.CHOL == null) {
                A.CHOL = new Zchol(A);
            }
            CHOL = A.CHOL;
        } else {
            CHOL = new Zchol(A);
        }
        return Solve.bahi(Solve.bai(B, CHOL.R), CHOL.R);
    }
}

