/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.ResultSet;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class RowType
extends Type {
    final Type[] dataTypes;

    public RowType(Type[] typeArray) {
        super(19, 19, 0L, 0);
        this.dataTypes = typeArray;
    }

    @Override
    public int displaySize() {
        return 0;
    }

    @Override
    public int getJDBCTypeCode() {
        return 0;
    }

    @Override
    public Class getJDBCClass() {
        return ResultSet.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.ResultSet";
    }

    @Override
    public Integer getJDBCScale() {
        return ValuePool.INTEGER_0;
    }

    @Override
    public int getJDBCPrecision() {
        return ValuePool.INTEGER_0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 19;
    }

    @Override
    public boolean isRowType() {
        return true;
    }

    @Override
    public String getNameString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ROW");
        stringBuffer.append('(');
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.dataTypes[i].getNameString());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    String getDefinition() {
        return this.getNameString();
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Object[] objectArray = (Object[])object2;
        Object[] objectArray2 = (Object[])object;
        int n = objectArray2.length;
        if (objectArray.length < n) {
            n = objectArray.length;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.dataTypes[i].compare(session, objectArray2[i], objectArray[i]);
            if (n2 == 0) continue;
            return n2;
        }
        if (objectArray2.length > objectArray.length) {
            return 1;
        }
        if (objectArray2.length < objectArray.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.dataTypes[i].convertToTypeLimits(sessionInterface, objectArray[i]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        if (object == null) {
            return null;
        }
        if (type == null) {
            return object;
        }
        if (!type.isRowType()) {
            throw Error.error(5562);
        }
        Type[] typeArray = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray.length) {
            throw Error.error(5564);
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.dataTypes[i].convertToType(sessionInterface, objectArray[i], typeArray[i]);
        }
        return objectArray2;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        return object;
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return this.convertToSQLString(object);
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        Object[] objectArray = (Object[])object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ROW");
        stringBuffer.append('(');
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.dataTypes[i].convertToSQLString(objectArray[i]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public boolean canConvertFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isRowType()) {
            return false;
        }
        Type[] typeArray = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray.length) {
            return false;
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.dataTypes[i].canConvertFrom(typeArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeAssignedFrom(Type type) {
        if (type == null) {
            return true;
        }
        if (!type.isRowType()) {
            return false;
        }
        Type[] typeArray = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray.length) {
            return false;
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            if (this.dataTypes[i].canBeAssignedFrom(typeArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == this) {
            return this;
        }
        if (!type.isRowType()) {
            throw Error.error(5562);
        }
        Type[] typeArray = new Type[this.dataTypes.length];
        Type[] typeArray2 = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray2.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            typeArray[i] = this.dataTypes[i].getAggregateType(typeArray2[i]);
        }
        return new RowType(typeArray);
    }

    @Override
    public Type getCombinedType(Type type, int n) {
        if (n != 36) {
            return this.getAggregateType(type);
        }
        if (type == null) {
            return this;
        }
        if (!type.isRowType()) {
            throw Error.error(5562);
        }
        Type[] typeArray = new Type[this.dataTypes.length];
        Type[] typeArray2 = ((RowType)type).getTypesArray();
        if (this.dataTypes.length != typeArray2.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.dataTypes.length; ++i) {
            typeArray[i] = this.dataTypes[i].getAggregateType(typeArray2[i]);
        }
        return new RowType(typeArray);
    }

    public Type[] getTypesArray() {
        return this.dataTypes;
    }
}

