/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionDefaults {
    private int holdability = -1;
    private int transactionIsolation = -1;
    private boolean isAutoCommit = true;
    private boolean isReadOnly = false;
    private String catalog = null;

    public ConnectionDefaults() {
    }

    public ConnectionDefaults(Connection connection) throws SQLException {
        this.holdability = connection.getHoldability();
        this.transactionIsolation = connection.getTransactionIsolation();
        this.isAutoCommit = connection.getAutoCommit();
        this.isReadOnly = connection.isReadOnly();
        this.catalog = connection.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    public void setHoldability(int n) throws SQLException {
        this.holdability = n;
    }

    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.isAutoCommit = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.isReadOnly = bl;
    }

    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    public void setCatalog(String string) throws SQLException {
        this.catalog = string;
    }

    public void setDefaults(Connection connection) throws SQLException {
        connection.setHoldability(this.holdability);
        if (this.transactionIsolation != 0) {
            connection.setTransactionIsolation(this.transactionIsolation);
        }
        connection.setAutoCommit(this.isAutoCommit);
        connection.setReadOnly(this.isReadOnly);
        connection.setCatalog(this.catalog);
    }
}

