/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import marytts.util.data.text.TextReaderDoubleDataSource;

public class PraatTextfileDoubleDataSource
extends TextReaderDoubleDataSource {
    public PraatTextfileDoubleDataSource(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public PraatTextfileDoubleDataSource(Reader reader) {
        super(reader);
        try {
            String line = this.reader.readLine().trim();
            if (!line.startsWith("File type = \"ooTextFile")) {
                throw new IllegalArgumentException("Expected Praat file, got first line: " + line);
            }
            line = this.reader.readLine();
            line = this.reader.readLine().trim();
            if (!line.equals("")) {
                throw new IllegalArgumentException("Expected empty third line, got: " + line);
            }
            line = this.reader.readLine();
            line = this.reader.readLine();
            line = this.reader.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        for (int i = 0; i < length; ++i) {
            try {
                double value;
                String line = this.reader.readLine();
                if (line == null) {
                    return i;
                }
                target[targetPos + i] = value = Double.parseDouble(line.trim());
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return i;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return i;
            }
        }
        return length;
    }
}

