/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class SequenceAudioInputStream
extends AudioInputStream {
    protected List<AudioInputStream> m_audioInputStreamList;
    protected int m_nCurrentStream;

    public SequenceAudioInputStream(AudioFormat audioFormat, Collection<AudioInputStream> audioInputStreams) {
        super(new ByteArrayInputStream(new byte[0]), audioFormat, -1L);
        this.m_audioInputStreamList = new ArrayList<AudioInputStream>(audioInputStreams);
        this.m_nCurrentStream = 0;
        Iterator<AudioInputStream> streamIterator = this.m_audioInputStreamList.iterator();
        this.frameLength = 0L;
        while (streamIterator.hasNext()) {
            AudioInputStream stream = streamIterator.next();
            long lLength = stream.getFrameLength();
            if (lLength == -1L) {
                this.frameLength = -1L;
                break;
            }
            this.frameLength += lLength;
        }
    }

    private AudioInputStream getCurrentStream() {
        return this.m_audioInputStreamList.get(this.m_nCurrentStream);
    }

    private boolean advanceStream() {
        ++this.m_nCurrentStream;
        boolean bAnotherStreamAvailable = this.m_nCurrentStream < this.m_audioInputStreamList.size();
        return bAnotherStreamAvailable;
    }

    @Override
    public int read() throws IOException {
        AudioInputStream stream = this.getCurrentStream();
        int nByte = stream.read();
        if (nByte == -1) {
            boolean bAnotherStreamAvailable = this.advanceStream();
            if (bAnotherStreamAvailable) {
                return this.read();
            }
            return -1;
        }
        return nByte;
    }

    @Override
    public int read(byte[] abData, int nOffset, int nLength) throws IOException {
        AudioInputStream stream = this.getCurrentStream();
        int nBytesRead = stream.read(abData, nOffset, nLength);
        if (nBytesRead == -1) {
            boolean bAnotherStreamAvailable = this.advanceStream();
            if (bAnotherStreamAvailable) {
                return this.read(abData, nOffset, nLength);
            }
            return -1;
        }
        return nBytesRead;
    }

    @Override
    public long skip(long lLength) throws IOException {
        throw new IOException("skip() is not implemented in class SequenceInputStream. Mail if you need this feature.");
    }

    @Override
    public int available() throws IOException {
        return this.getCurrentStream().available();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int nReadLimit) {
        throw new RuntimeException("mark() is not implemented in class SequenceInputStream. Mail if you need this feature.");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() is not implemented in class SequenceInputStream. Mail if you need this feature.");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

