/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.util.data.audio.MonoAudioInputStream;
import marytts.util.data.audio.StereoAudioInputStream;

public class AudioPlayer
extends Thread {
    public static final int MONO = 0;
    public static final int STEREO = 3;
    public static final int LEFT_ONLY = 1;
    public static final int RIGHT_ONLY = 2;
    private AudioInputStream ais;
    private LineListener lineListener;
    private SourceDataLine line;
    private int outputMode;
    private Status status = Status.WAITING;
    private boolean exitRequested = false;

    public AudioPlayer() {
    }

    public AudioPlayer(File audioFile) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
    }

    public AudioPlayer(AudioInputStream ais) {
        this.ais = ais;
    }

    public AudioPlayer(File audioFile, LineListener lineListener) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
        this.lineListener = lineListener;
    }

    public AudioPlayer(AudioInputStream ais, LineListener lineListener) {
        this.ais = ais;
        this.lineListener = lineListener;
    }

    public AudioPlayer(File audioFile, SourceDataLine line, LineListener lineListener) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
        this.line = line;
        this.lineListener = lineListener;
    }

    public AudioPlayer(AudioInputStream ais, SourceDataLine line, LineListener lineListener) {
        this.ais = ais;
        this.line = line;
        this.lineListener = lineListener;
    }

    public AudioPlayer(File audioFile, SourceDataLine line, LineListener lineListener, int outputMode) throws IOException, UnsupportedAudioFileException {
        this.ais = AudioSystem.getAudioInputStream(audioFile);
        this.line = line;
        this.lineListener = lineListener;
        this.outputMode = outputMode;
    }

    public AudioPlayer(AudioInputStream ais, SourceDataLine line, LineListener lineListener, int outputMode) {
        this.ais = ais;
        this.line = line;
        this.lineListener = lineListener;
        this.outputMode = outputMode;
    }

    public void setAudio(AudioInputStream audio) {
        if (this.status == Status.PLAYING) {
            throw new IllegalStateException("Cannot set audio while playing");
        }
        this.ais = audio;
    }

    public void cancel() {
        if (this.line != null) {
            this.line.stop();
        }
        this.exitRequested = true;
    }

    public SourceDataLine getLine() {
        return this.line;
    }

    @Override
    public void run() {
        this.status = Status.PLAYING;
        AudioFormat audioFormat = this.ais.getFormat();
        if (audioFormat.getChannels() == 1) {
            if (this.outputMode != 0) {
                this.ais = new StereoAudioInputStream(this.ais, this.outputMode);
                audioFormat = this.ais.getFormat();
            }
        } else {
            assert (audioFormat.getChannels() == 2) : "Unexpected number of channels: " + audioFormat.getChannels();
            if (this.outputMode == 0) {
                this.ais = new MonoAudioInputStream(this.ais);
            } else if (this.outputMode == 1) {
                this.ais = new StereoAudioInputStream(this.ais, this.outputMode);
            } else if (this.outputMode == 2) {
                this.ais = new StereoAudioInputStream(this.ais, this.outputMode);
            } else assert (this.outputMode == 3) : "Unexpected output mode: " + this.outputMode;
        }
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            if (this.line == null) {
                boolean bIsSupportedDirectly = AudioSystem.isLineSupported(info);
                if (!bIsSupportedDirectly) {
                    AudioFormat sourceFormat = audioFormat;
                    AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), sourceFormat.getChannels() * (sourceFormat.getSampleSizeInBits() / 8), sourceFormat.getSampleRate(), sourceFormat.isBigEndian());
                    this.ais = AudioSystem.getAudioInputStream(targetFormat, this.ais);
                    audioFormat = this.ais.getFormat();
                }
                info = new DataLine.Info(SourceDataLine.class, audioFormat);
                this.line = (SourceDataLine)AudioSystem.getLine(info);
            }
            if (this.lineListener != null) {
                this.line.addLineListener(this.lineListener);
            }
            this.line.open(audioFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.line.start();
        int nRead = 0;
        byte[] abData = new byte[65532];
        while (nRead != -1 && !this.exitRequested) {
            try {
                nRead = this.ais.read(abData, 0, abData.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nRead < 0) continue;
            this.line.write(abData, 0, nRead);
        }
        if (!this.exitRequested) {
            this.line.drain();
        }
        this.line.close();
    }

    public static void main(String[] args) throws Exception {
        int i;
        boolean listFilename = false;
        if (args[0].equals("-l")) {
            listFilename = true;
        }
        int n = i = listFilename ? 1 : 0;
        while (i < args.length) {
            AudioPlayer player = new AudioPlayer(new File(args[i]), null);
            if (listFilename) {
                System.out.println(args[i]);
            }
            player.start();
            player.join();
            ++i;
        }
        System.exit(0);
    }

    public static enum Status {
        WAITING,
        PLAYING;

    }
}

