/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import marytts.features.FeatureVector;
import marytts.unitselection.data.FeatureFileReader;

public class Syllable {
    private FeatureFileReader features;
    private int firstUnitIndex;
    private int lastUnitIndex;

    public Syllable(FeatureFileReader features, int firstUnitIndex, int lastUnitIndex) {
        this.features = features;
        this.firstUnitIndex = firstUnitIndex;
        this.lastUnitIndex = lastUnitIndex;
    }

    public int getFirstUnitIndex() {
        return this.firstUnitIndex;
    }

    public int getLastUnitIndex() {
        return this.lastUnitIndex;
    }

    public int getSyllableNucleusIndex() {
        int fiVowel = this.features.getFeatureDefinition().getFeatureIndex("ph_vc");
        byte fvVowel_Plus = this.features.getFeatureDefinition().getFeatureValueAsByte(fiVowel, "+");
        for (int i = this.firstUnitIndex; i <= this.lastUnitIndex; ++i) {
            FeatureVector fv = this.features.getFeatureVector(i);
            if (fv.getByteFeature(fiVowel) != fvVowel_Plus) continue;
            return i;
        }
        return this.lastUnitIndex;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Syllable)) {
            return false;
        }
        Syllable other = (Syllable)o;
        return this.features.equals(other.features) && this.firstUnitIndex == other.firstUnitIndex && this.lastUnitIndex == other.lastUnitIndex;
    }
}

