/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.analysis;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.server.MaryProperties;
import marytts.unitselection.data.FeatureFileReader;
import marytts.unitselection.data.TimelineReader;
import marytts.unitselection.data.Unit;
import marytts.unitselection.data.UnitDatabase;
import marytts.unitselection.data.UnitFileReader;
import marytts.util.data.Datagram;
import marytts.util.data.text.PraatInterval;
import marytts.util.data.text.PraatIntervalTier;
import marytts.util.data.text.PraatTextGrid;

public class VoiceDataDumper {
    protected UnitDatabase unitDB;
    protected FeatureFileReader featureFileReader;
    protected long numSamples = 0L;
    protected FeatureDefinition featureDefinition;
    protected int phoneFeatureIndex;
    protected int halfphoneLRFeatureIndex;

    protected int byteswap(int val) {
        return ((val & 0xFF000000) >>> 24) + ((val & 0xFF0000) >>> 8) + ((val & 0xFF00) << 8) + ((val & 0xFF) << 24);
    }

    protected short byteswap(short val) {
        return (short)(((val & 0xFF00) >>> 8) + ((val & 0xFF) << 8));
    }

    protected TimelineReader loadAudioTimeline(String fileName) throws IOException, MaryConfigurationException {
        return new TimelineReader(fileName);
    }

    protected void loadUnitDatabase(String audioTimelineFileName, String basenameTimelineFileName, String unitFileName) throws IOException, MaryConfigurationException {
        this.unitDB = new UnitDatabase();
        UnitFileReader unitFileReader = new UnitFileReader(unitFileName);
        TimelineReader audioTimelineReader = this.loadAudioTimeline(audioTimelineFileName);
        TimelineReader basenameTimelineReader = new TimelineReader(basenameTimelineFileName);
        this.unitDB.load(null, null, unitFileReader, null, audioTimelineReader, basenameTimelineReader, 0);
    }

    protected void loadFeatureFile(String fileName) throws IOException, MaryConfigurationException {
        this.featureFileReader = new FeatureFileReader(fileName);
        this.featureDefinition = this.featureFileReader.getFeatureDefinition();
        this.phoneFeatureIndex = this.featureDefinition.getFeatureIndex("phone");
        this.halfphoneLRFeatureIndex = this.featureDefinition.getFeatureIndex("halfphone_lr");
    }

    protected double getDuration(Datagram[] datagrams) {
        double totalDuration = 0.0;
        for (Datagram datagram : datagrams) {
            totalDuration += (double)((float)datagram.getDuration() / (float)this.unitDB.getAudioTimeline().getSampleRate());
        }
        return totalDuration;
    }

    protected byte[] getSamples(Datagram[] datagrams) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (Datagram datagram : datagrams) {
            byte[] data = datagram.getData();
            baos.write(data);
        }
        byte[] samples = baos.toByteArray();
        return samples;
    }

    protected void dumpTextGrid(String fileName) throws IOException {
        PraatIntervalTier unitTier = new PraatIntervalTier("unitindex");
        PraatIntervalTier phoneTier = new PraatIntervalTier("halfphone");
        PraatIntervalTier basenameTier = new PraatIntervalTier("basename");
        double prevHalfPhoneUnitDurationInSeconds = 0.0;
        double basenameDurationInSeconds = 0.0;
        String basenameLabel = null;
        for (int unitIndex = 0; unitIndex < this.unitDB.getUnitFileReader().getNumberOfUnits(); ++unitIndex) {
            Unit unit = this.unitDB.getUnitFileReader().getUnit(unitIndex);
            if (unit.isEdgeUnit()) {
                if (!(basenameDurationInSeconds > 0.0)) continue;
                PraatInterval basenameInterval = new PraatInterval(basenameDurationInSeconds, basenameLabel);
                basenameTier.appendInterval(basenameInterval);
                basenameDurationInSeconds = 0.0;
                continue;
            }
            Datagram[] datagrams = this.unitDB.getAudioTimeline().getDatagrams(unit, this.unitDB.getAudioTimeline().getSampleRate());
            double halfPhoneUnitDurationInSeconds = this.getDuration(datagrams);
            byte[] buf = this.getSamples(datagrams);
            this.numSamples += (long)buf.length;
            basenameDurationInSeconds += halfPhoneUnitDurationInSeconds;
            basenameLabel = this.unitDB.getFilename(unit);
            PraatInterval interval = new PraatInterval(halfPhoneUnitDurationInSeconds, Integer.toString(unit.index));
            unitTier.appendInterval(interval);
            FeatureVector features = this.featureFileReader.getFeatureVector(unit);
            String halfphoneLR = features.getFeatureAsString(this.halfphoneLRFeatureIndex, this.featureDefinition);
            if (halfphoneLR.equals("R")) {
                double phoneUnitDurationInSeconds = halfPhoneUnitDurationInSeconds + prevHalfPhoneUnitDurationInSeconds;
                String phoneLabel = features.getFeatureAsString(this.phoneFeatureIndex, this.featureDefinition);
                PraatInterval phoneInterval = new PraatInterval(phoneUnitDurationInSeconds, phoneLabel);
                phoneTier.appendInterval(phoneInterval);
            }
            prevHalfPhoneUnitDurationInSeconds = halfPhoneUnitDurationInSeconds;
        }
        unitTier.updateBoundaries();
        phoneTier.updateBoundaries();
        basenameTier.updateBoundaries();
        PraatTextGrid textGrid = new PraatTextGrid();
        textGrid.appendTier(unitTier);
        textGrid.appendTier(phoneTier);
        textGrid.appendTier(basenameTier);
        BufferedWriter output = new BufferedWriter(new PrintWriter(fileName));
        output.write(textGrid.toString());
        output.close();
    }

    protected void dumpAudio(String fileName) throws IOException {
        if (this.numSamples <= 0L) {
            return;
        }
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        int nBytesPerSample = 2;
        dos.writeBytes("RIFF");
        dos.writeInt(this.byteswap((int)(36L + this.numSamples)));
        dos.writeBytes("WAVEfmt ");
        dos.writeInt(this.byteswap(16));
        dos.writeShort(this.byteswap((short)1));
        dos.writeShort(this.byteswap((short)1));
        dos.writeInt(this.byteswap(this.unitDB.getAudioTimeline().getSampleRate()));
        dos.writeInt(this.byteswap(this.unitDB.getAudioTimeline().getSampleRate() * nBytesPerSample));
        dos.writeShort(this.byteswap((short)nBytesPerSample));
        dos.writeShort(this.byteswap((short)(nBytesPerSample * 8)));
        dos.writeBytes("data");
        dos.writeInt(this.byteswap((int)this.numSamples));
        for (int unitIndex = 0; unitIndex < this.unitDB.getUnitFileReader().getNumberOfUnits(); ++unitIndex) {
            Unit unit = this.unitDB.getUnitFileReader().getUnit(unitIndex);
            if (unit.isEdgeUnit()) continue;
            Datagram[] datagrams = this.unitDB.getAudioTimeline().getDatagrams(unit, this.unitDB.getAudioTimeline().getSampleRate());
            byte[] buf = this.getSamples(datagrams);
            byte b = 0;
            for (int j = 0; j < buf.length - 1; j += 2) {
                b = buf[j];
                buf[j] = buf[j + 1];
                buf[j + 1] = b;
            }
            dos.write(buf);
        }
        dos.close();
    }

    protected void dumpData(String voiceName) throws Exception {
        String audioTimelineFileName = MaryProperties.needFilename("voice." + voiceName + ".audioTimelineFile");
        String basenameTimelineFileName = MaryProperties.needFilename("voice." + voiceName + ".basenameTimeline");
        String unitFileName = MaryProperties.needFilename("voice." + voiceName + ".unitsFile");
        String featureFileName = MaryProperties.needFilename("voice." + voiceName + ".featureFile");
        String textGridFilename = audioTimelineFileName.replace(".mry", ".TextGrid");
        String wavFilename = audioTimelineFileName.replace(".mry", ".wav");
        this.loadUnitDatabase(audioTimelineFileName, basenameTimelineFileName, unitFileName);
        this.loadFeatureFile(featureFileName);
        System.out.println("All files loaded.");
        this.dumpTextGrid(textGridFilename);
        System.out.println("Dumped TextGrid to " + textGridFilename);
        this.dumpAudio(wavFilename);
        System.out.println("Dumped audio to " + wavFilename);
    }

    public static void main(String[] args) throws Exception {
        new VoiceDataDumper().dumpData(args[0]);
    }
}

