/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.pitch;

import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechSignal;
import marytts.util.math.MathUtils;

public class BaseSinusoidalPitchTracker {
    float[] f0s;
    double[] Qs;

    public float[] pitchTrack(NonharmonicSinusoidalSpeechSignal sinSignal, int samplingRate, float searchStepInHz, float minFreqInHz, float maxFreqInHz) {
        this.f0s = null;
        this.Qs = null;
        if (sinSignal.framesSins.length > 0) {
            this.f0s = new float[sinSignal.framesSins.length];
            this.Qs = new double[sinSignal.framesSins.length];
            for (int i = 0; i < sinSignal.framesSins.length; ++i) {
                F0Value v = this.pitchAnalyzeFrame(sinSignal.framesSins[i], samplingRate, searchStepInHz, minFreqInHz, maxFreqInHz);
                this.f0s[i] = v.f0;
                this.Qs[i] = v.maxQ;
            }
            this.f0s = this.postProcessTrack(this.f0s, this.Qs);
        }
        return this.f0s;
    }

    public F0Value pitchAnalyzeFrame(NonharmonicSinusoidalSpeechFrame sinFrame, int samplingRate, float searchStepInHz, float minFreqInHz, float maxFreqInHz) {
        int i;
        F0Value v = new F0Value();
        double[] Q = null;
        if (sinFrame != null) {
            int numCandidates = (int)Math.floor((double)((maxFreqInHz - minFreqInHz) / searchStepInHz + 1.0f) + 0.5);
            Q = new double[numCandidates];
            for (i = 0; i < numCandidates; ++i) {
                float w0 = (float)i * searchStepInHz + minFreqInHz;
                Q[i] = this.performanceCriterion(sinFrame, w0, samplingRate);
            }
        }
        if (Q != null) {
            v.maxQ = MathUtils.getMax(Q);
            int numNeighs = (int)Math.floor((double)(10.0f / searchStepInHz) + 0.5);
            int[] maxInds = MathUtils.getExtrema(Q, numNeighs, numNeighs, true, 0, Q.length - 1, 0.1 * v.maxQ);
            if (maxInds != null) {
                int maxInd = 0;
                v.maxQ = Q[maxInds[maxInd]];
                for (i = 1; i < maxInds.length; ++i) {
                    if (!(Q[maxInds[i]] > v.maxQ)) continue;
                    v.maxQ = Q[maxInds[i]];
                    maxInd = i;
                }
                v.f0 = (float)maxInds[maxInd] * searchStepInHz + minFreqInHz;
            }
        }
        if (v.maxQ < 5.0E-5) {
            v.f0 = 0.0f;
        }
        char chTab = '\t';
        System.out.println(String.valueOf(v.f0) + chTab + String.valueOf(v.maxQ));
        return v;
    }

    public double performanceCriterion(NonharmonicSinusoidalSpeechFrame sinFrame, float f0Candidate, int samplingRate) {
        return -1.0;
    }

    public float[] postProcessTrack(float[] f0sIn, double[] QsIn) {
        float[] f0sOut = null;
        if (f0sIn != null) {
            int i;
            int numfrm = f0sIn.length;
            int contextCount = 1;
            f0sOut = new float[numfrm];
            System.arraycopy(f0sIn, 0, f0sOut, 0, numfrm);
            for (i = 1; i < numfrm - 1; ++i) {
                if (f0sOut[i] <= 10.0f && f0sOut[i - 1] > 10.0f && f0sOut[i + 1] > 10.0f) {
                    f0sOut[i] = 0.5f * (f0sOut[i - 1] + f0sOut[i + 1]);
                    continue;
                }
                if (!(f0sOut[i] > 10.0f) || !(f0sOut[i - 1] <= 10.0f) || !(f0sOut[i + 1] <= 10.0f)) continue;
                f0sOut[i] = 0.0f;
            }
            for (i = contextCount; i < numfrm - contextCount; ++i) {
                int j;
                boolean bAllVoiced = true;
                for (j = -contextCount; j <= contextCount; ++j) {
                    if (!(f0sOut[i + j] < 10.0f)) continue;
                    bAllVoiced = false;
                    break;
                }
                if (!bAllVoiced) continue;
                float avgContextF0 = 0.0f;
                for (j = -contextCount; j < 0; ++j) {
                    avgContextF0 += f0sOut[i + j];
                }
                for (j = 1; j <= contextCount; ++j) {
                    avgContextF0 += f0sOut[i + j];
                }
                if (Math.abs((double)f0sOut[i] - 0.5 * (double)(avgContextF0 /= 2.0f * (float)contextCount)) < 10.0) {
                    int n = i;
                    f0sOut[n] = f0sOut[n] * 2.0f;
                    continue;
                }
                if (!(Math.abs((double)f0sOut[i] - 2.0 * (double)avgContextF0) < 10.0)) continue;
                int n = i;
                f0sOut[n] = f0sOut[n] * 0.5f;
            }
        }
        return f0sOut;
    }

    public class F0Value {
        public float f0 = 0.0f;
        public double maxQ = 0.0;
    }
}

