/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.util.Arrays;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.window.Window;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class NoisePartLpFilterPostHpfLpcSynthesizer {
    public static double[] synthesize(HntmSpeechSignal hnmSignal, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParams) {
        boolean isNoised;
        int i;
        double[] noisePart = null;
        double[] noisePart2 = null;
        double[] weights = null;
        float tsi = 0.0f;
        int startIndex = 0;
        int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
        int lpOrder = 0;
        double[] excitation = MathUtils.random(outputLen, -0.5, 0.5);
        int fftSizeNoise = SignalProcUtils.getDFTSize(hnmSignal.samplingRateInHz);
        for (i = 0; i < hnmSignal.frames.length; ++i) {
            boolean bl = isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
            if (!isNoised || hnmSignal.frames[i].n == null || !(hnmSignal.frames[i].n instanceof FrameNoisePartLpc) || ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs == null) continue;
            lpOrder = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs.length;
            break;
        }
        if (lpOrder > 0) {
            int j;
            int n;
            int pmIndNext;
            noisePart = new double[outputLen];
            Arrays.fill(noisePart, 0.0);
            noisePart2 = new double[outputLen];
            Arrays.fill(noisePart2, 0.0);
            weights = new double[outputLen];
            Arrays.fill(weights, 0.0);
            boolean bFirst = true;
            int pmInd = 0;
            int start = 0;
            double[] tmpy = null;
            double[] tmpalpha = null;
            for (i = 0; i < hnmSignal.frames.length; ++i) {
                pmInd = SignalProcUtils.time2sample(hnmSignal.frames[i].tAnalysisInSeconds, hnmSignal.samplingRateInHz);
                pmIndNext = i < hnmSignal.frames.length - 1 ? SignalProcUtils.time2sample(hnmSignal.frames[i + 1].tAnalysisInSeconds, hnmSignal.samplingRateInHz) : outputLen - 1;
                start = pmInd;
                boolean bl = isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc && ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs != null) {
                    double tmp;
                    int count;
                    if (i < hnmSignal.frames.length - 1) {
                        for (n = 0; n <= pmIndNext - pmInd; ++n) {
                            tmpy = new double[Math.max(start - 1, 0) - Math.max(start - lpOrder, 0) + 1];
                            count = 0;
                            for (j = Math.max(start - 1, 0); j >= Math.max(start - lpOrder, 0); --j) {
                                tmpy[count++] = noisePart[j];
                            }
                            tmpalpha = new double[tmpy.length];
                            for (j = 0; j < tmpy.length; ++j) {
                                tmpalpha[j] = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs[j];
                            }
                            tmp = 0.0;
                            for (j = 0; j < tmpalpha.length; ++j) {
                                tmp += tmpalpha[j] * tmpy[j];
                            }
                            if (start < outputLen) {
                                noisePart[start] = (double)((FrameNoisePartLpc)hnmSignal.frames[i].n).lpGain * excitation[start] + tmp;
                                ++start;
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (n = 0; n < outputLen - pmInd; ++n) {
                            tmpy = new double[Math.max(start - 1, 0) - Math.max(start - lpOrder, 0) + 1];
                            count = 0;
                            for (j = Math.max(start - 1, 0); j >= Math.max(start - lpOrder, 0); --j) {
                                tmpy[count++] = noisePart[j];
                            }
                            tmpalpha = new double[tmpy.length];
                            for (j = 0; j < tmpy.length; ++j) {
                                tmpalpha[j] = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs[j];
                            }
                            tmp = 0.0;
                            for (j = 0; j < tmpalpha.length; ++j) {
                                tmp += tmpalpha[j] * tmpy[j];
                            }
                            if (start < outputLen) {
                                noisePart[start] = (double)((FrameNoisePartLpc)hnmSignal.frames[i].n).lpGain * excitation[start] + tmp;
                                ++start;
                                continue;
                            }
                            break;
                        }
                    }
                }
                pmInd = pmIndNext;
            }
            if (analysisParams.preemphasisCoefNoise > 0.0f) {
                noisePart = SignalProcUtils.removePreemphasis(noisePart, analysisParams.preemphasisCoefNoise);
            }
            MathUtils.adjustMean(noisePart, 0.0);
            int startInd = 0;
            for (i = 0; i < hnmSignal.frames.length - 2; ++i) {
                pmInd = SignalProcUtils.time2sample(hnmSignal.frames[i].tAnalysisInSeconds, hnmSignal.samplingRateInHz);
                pmIndNext = i <= hnmSignal.frames.length - 3 ? SignalProcUtils.time2sample(hnmSignal.frames[i + 2].tAnalysisInSeconds, hnmSignal.samplingRateInHz) : outputLen - 1;
                startInd = start = pmInd;
                boolean isPrevNoised = false;
                if (i > 0) {
                    isPrevNoised = hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                }
                isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                boolean isNextNoised = false;
                if (i < hnmSignal.frames.length - 1) {
                    boolean bl = isNextNoised = hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                }
                if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc && ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs != null) {
                    int halfLen;
                    int endInd = Math.min(pmIndNext, outputLen - 1);
                    double[] tmpFrm = ArrayUtils.subarray(noisePart, startInd, endInd - startInd + 1);
                    if (synthesisParams.hpfAfterNoiseSynthesis && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz - analysisParams.overlapBetweenHarmonicAndNoiseRegionsInHz > 0.0f) {
                        tmpFrm = SignalProcUtils.fdFilter(tmpFrm, hnmSignal.frames[i].maximumFrequencyOfVoicingInHz - analysisParams.overlapBetweenHarmonicAndNoiseRegionsInHz, 0.5f * (float)hnmSignal.samplingRateInHz, hnmSignal.samplingRateInHz, fftSizeNoise);
                    }
                    tmpFrm = SignalProcUtils.normalizeAverageSampleEnergy(tmpFrm, ((FrameNoisePartLpc)hnmSignal.frames[i].n).origAverageSampleEnergy);
                    Window winNoise = Window.get(analysisParams.noiseAnalysisWindowType, endInd - startInd + 1);
                    winNoise.normalizePeakValue(1.0f);
                    double[] wgtNoise = winNoise.getCoeffs();
                    if (!isPrevNoised) {
                        halfLen = (int)Math.floor(0.5 * (double)tmpFrm.length + 0.5);
                        for (j = 0; j < halfLen; ++j) {
                            int n2 = startInd + j;
                            noisePart2[n2] = noisePart2[n2] + tmpFrm[j] * wgtNoise[j];
                        }
                        for (j = halfLen + 1; j < tmpFrm.length; ++j) {
                            int n3 = startInd + j;
                            noisePart2[n3] = noisePart2[n3] + tmpFrm[j] * wgtNoise[j];
                            int n4 = startInd + j;
                            weights[n4] = weights[n4] + wgtNoise[j];
                        }
                    } else if (!isNextNoised) {
                        halfLen = (int)Math.floor(0.5 * (double)tmpFrm.length + 0.5);
                        for (j = 0; j < halfLen; ++j) {
                            int n5 = startInd + j;
                            noisePart2[n5] = noisePart2[n5] + tmpFrm[j] * wgtNoise[j];
                            int n6 = startInd + j;
                            weights[n6] = weights[n6] + wgtNoise[j];
                        }
                        for (j = halfLen + 1; j < tmpFrm.length; ++j) {
                            int n7 = startInd + j;
                            noisePart2[n7] = noisePart2[n7] + tmpFrm[j] * wgtNoise[j];
                        }
                    } else {
                        for (j = 0; j < tmpFrm.length; ++j) {
                            int n8 = startInd + j;
                            noisePart2[n8] = noisePart2[n8] + tmpFrm[j] * wgtNoise[j];
                            int n9 = startInd + j;
                            weights[n9] = weights[n9] + wgtNoise[j];
                        }
                    }
                }
                pmInd = pmIndNext;
            }
            for (i = 0; i < outputLen; ++i) {
                if (!(weights[i] > 1.0E-20)) continue;
                int n10 = i;
                noisePart2[n10] = noisePart2[n10] / weights[i];
            }
            System.arraycopy(noisePart2, 0, noisePart, 0, outputLen);
            if (synthesisParams.applyTriangularNoiseEnvelopeForVoicedParts) {
                float tsiNext = 0.0f;
                for (i = 0; i < hnmSignal.frames.length; ++i) {
                    int startIndexNext;
                    boolean isVoiced;
                    boolean bl = isVoiced = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz > 0.0f;
                    if (!isVoiced) continue;
                    tsi = i == 0 ? 0.0f : hnmSignal.frames[i].tAnalysisInSeconds;
                    startIndex = SignalProcUtils.time2sample(tsi, hnmSignal.samplingRateInHz);
                    if (i < hnmSignal.frames.length - 1) {
                        tsiNext = Math.max(0.0f, hnmSignal.frames[i + 1].tAnalysisInSeconds);
                        startIndexNext = SignalProcUtils.time2sample(tsiNext, hnmSignal.samplingRateInHz);
                    } else {
                        startIndexNext = outputLen - 1;
                        tsiNext = SignalProcUtils.sample2time(startIndexNext, hnmSignal.samplingRateInHz);
                    }
                    int enEnvLen = startIndexNext - startIndex + 1;
                    if (enEnvLen <= 0) continue;
                    double[] enEnv = new double[enEnvLen];
                    int l1 = SignalProcUtils.time2sample(0.15 * (double)(tsiNext - tsi), hnmSignal.samplingRateInHz);
                    int l2 = SignalProcUtils.time2sample(0.85 * (double)(tsiNext - tsi), hnmSignal.samplingRateInHz);
                    int lMid = (int)Math.floor(0.5 * (double)(l1 + l2) + 0.5);
                    for (n = 0; n < l1; ++n) {
                        enEnv[n] = synthesisParams.energyTriangleLowerValue;
                    }
                    for (n = l1; n < lMid; ++n) {
                        enEnv[n] = (double)(n - l1) * (synthesisParams.energyTriangleUpperValue - synthesisParams.energyTriangleLowerValue) / (double)(lMid - l1) + synthesisParams.energyTriangleLowerValue;
                    }
                    for (n = lMid; n < l2; ++n) {
                        enEnv[n] = (double)(n - lMid) * (synthesisParams.energyTriangleLowerValue - synthesisParams.energyTriangleUpperValue) / (double)(l2 - lMid) + synthesisParams.energyTriangleUpperValue;
                    }
                    for (n = l2; n < enEnvLen; ++n) {
                        enEnv[n] = synthesisParams.energyTriangleLowerValue;
                    }
                    for (n = startIndex; n <= Math.min(noisePart.length - 1, startIndexNext); ++n) {
                        int n11 = n;
                        noisePart[n11] = noisePart[n11] * enEnv[n - startIndex];
                    }
                }
            }
        }
        return noisePart;
    }
}

