/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class HarmonicPartLinearPhaseInterpolatorSynthesizer {
    private double[] harmonicPart = null;
    private double[][] harmonicTracks;
    private double[][] winOverlapWgt;
    private HntmAnalyzerParams analysisParams;
    private HntmSynthesizerParams synthesisParams;
    private int transitionLen;
    private double[] halfTransitionWinLeft;
    private double[] halfTransitionWinRight;
    private String referenceFile;
    private int pipeOutStartIndex;
    private int pipeOutEndIndex;
    private int currentFrameIndex;
    private HntmSpeechSignal hnmSignal;
    private boolean isReseted;

    public HarmonicPartLinearPhaseInterpolatorSynthesizer(HntmSpeechSignal hnmSignalIn, HntmAnalyzerParams analysisParamsIn, HntmSynthesizerParams synthesisParamsIn) {
        this(hnmSignalIn, analysisParamsIn, synthesisParamsIn, null);
    }

    public HarmonicPartLinearPhaseInterpolatorSynthesizer(HntmSpeechSignal hnmSignalIn, HntmAnalyzerParams analysisParamsIn, HntmSynthesizerParams synthesisParamsIn, String referenceFileIn) {
        this.hnmSignal = hnmSignalIn;
        this.harmonicPart = null;
        this.harmonicTracks = null;
        this.winOverlapWgt = null;
        this.analysisParams = analysisParamsIn;
        this.synthesisParams = synthesisParamsIn;
        this.referenceFile = referenceFileIn;
        this.transitionLen = SignalProcUtils.time2sample(this.synthesisParams.unvoicedVoicedTrackTransitionInSeconds, this.hnmSignal.samplingRateInHz);
        Window transitionWin = Window.get(1, this.transitionLen * 2);
        transitionWin.normalizePeakValue(1.0f);
        this.halfTransitionWinLeft = transitionWin.getCoeffsLeftHalf();
        this.halfTransitionWinRight = transitionWin.getCoeffsRightHalf();
        this.isReseted = false;
        this.reset();
    }

    public void reset() {
        if (!this.isReseted) {
            this.isReseted = true;
            int outputLen = SignalProcUtils.time2sample(this.hnmSignal.originalDurationInSeconds, this.hnmSignal.samplingRateInHz);
            this.harmonicPart = new double[outputLen];
            Arrays.fill(this.harmonicPart, 0.0);
            if (this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumTotalHarmonics > 0) {
                this.harmonicTracks = new double[this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumTotalHarmonics][];
                this.winOverlapWgt = new double[this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumTotalHarmonics][];
                for (int k = 0; k < this.analysisParams.hnmPitchVoicingAnalyzerParams.maximumTotalHarmonics; ++k) {
                    this.harmonicTracks[k] = new double[outputLen];
                    Arrays.fill(this.harmonicTracks[k], 0.0);
                    if (!this.synthesisParams.overlappingHarmonicPartSynthesis) continue;
                    this.winOverlapWgt[k] = new double[outputLen];
                    Arrays.fill(this.winOverlapWgt[k], 0.0);
                }
            }
            this.pipeOutStartIndex = 0;
            this.pipeOutEndIndex = -1;
            this.currentFrameIndex = 0;
        }
    }

    public boolean isReseted() {
        return this.isReseted;
    }

    public boolean nextFrameAvailable() {
        return this.currentFrameIndex + 1 < this.hnmSignal.frames.length;
    }

    public double[] synthesizeAll() {
        this.reset();
        double[] output = null;
        int harmonicPartIndex = 0;
        while (this.nextFrameAvailable()) {
            output = this.synthesizeNext();
            if (output == null) continue;
            System.arraycopy(output, 0, this.harmonicPart, harmonicPartIndex, output.length);
            harmonicPartIndex += output.length;
        }
        output = this.generateOutput(true);
        if (output != null) {
            System.arraycopy(output, 0, this.harmonicPart, harmonicPartIndex, output.length);
            harmonicPartIndex += output.length;
        }
        return this.harmonicPart;
    }

    public double[] synthesizeNext() {
        assert (this.currentFrameIndex < this.hnmSignal.frames.length);
        double[] output = null;
        HntmSpeechFrame prevFrame = this.currentFrameIndex > 0 ? this.hnmSignal.frames[this.currentFrameIndex - 1] : null;
        HntmSpeechFrame nextFrame = this.currentFrameIndex < this.hnmSignal.frames.length - 1 ? this.hnmSignal.frames[this.currentFrameIndex + 1] : null;
        boolean isFirstSynthesisFrame = false;
        if (this.currentFrameIndex == 0) {
            isFirstSynthesisFrame = true;
        }
        boolean isLastSynthesisFrame = false;
        if (this.currentFrameIndex == this.hnmSignal.frames.length - 1) {
            isLastSynthesisFrame = true;
        }
        this.processFrame(prevFrame, this.hnmSignal.frames[this.currentFrameIndex], nextFrame, isFirstSynthesisFrame, isLastSynthesisFrame);
        if (this.currentFrameIndex > this.synthesisParams.synthesisFramesToAccumulateBeforeAudioGeneration) {
            this.pipeOutEndIndex = SignalProcUtils.time2sample(this.hnmSignal.frames[this.currentFrameIndex - this.synthesisParams.synthesisFramesToAccumulateBeforeAudioGeneration].tAnalysisInSeconds, this.hnmSignal.samplingRateInHz);
            output = this.generateOutput(false);
        }
        this.isReseted = false;
        ++this.currentFrameIndex;
        return output;
    }

    private void processFrame(HntmSpeechFrame prevFrame, HntmSpeechFrame currentFrame, HntmSpeechFrame nextFrame, boolean isFirstSynthesisFrame, boolean isLastSynthesisFrame) {
        float[] currentCeps = null;
        float[] nextCeps = null;
        boolean isPrevVoiced = false;
        boolean isVoiced = false;
        boolean isNextVoiced = false;
        double phasekt = 0.0;
        double phasekiEstimate = 0.0;
        double phasekiPlusOneEstimate = 0.0;
        double tsik = 0.0;
        double tsikPlusOne = 0.0;
        if (prevFrame != null && prevFrame.h != null && prevFrame.h.complexAmps != null && prevFrame.h.complexAmps.length > 0) {
            isPrevVoiced = true;
        }
        if (currentFrame.h != null && currentFrame.h.complexAmps != null && currentFrame.h.complexAmps.length > 0) {
            isVoiced = true;
        }
        if (nextFrame != null && nextFrame.h != null && nextFrame.h.complexAmps != null && nextFrame.h.complexAmps.length > 0) {
            isNextVoiced = true;
        }
        int numHarmonicsCurrentFrame = isVoiced ? currentFrame.h.complexAmps.length : (!isVoiced && isNextVoiced ? nextFrame.h.complexAmps.length : 0);
        float f0InHz = currentFrame.f0InHz;
        float f0InHzNext = isNextVoiced ? nextFrame.f0InHz : f0InHz;
        float f0Average = 0.5f * (f0InHz + f0InHzNext);
        if (!this.analysisParams.useHarmonicAmplitudesDirectly) {
            currentCeps = currentFrame.h.getCeps(f0InHz, this.hnmSignal.samplingRateInHz, this.analysisParams);
            nextCeps = nextFrame != null ? nextFrame.h.getCeps(f0InHzNext, this.hnmSignal.samplingRateInHz, this.analysisParams) : null;
        }
        for (int k = 0; k < numHarmonicsCurrentFrame; ++k) {
            int currentHarmonicNo = k + 1;
            double aksi = 0.0;
            double aksiPlusOne = 0.0;
            double phaseki = 0.0;
            double phasekiPlusOne = 0.0;
            boolean isPrevTrackVoiced = false;
            boolean isTrackVoiced = false;
            boolean isNextTrackVoiced = false;
            if (prevFrame != null && prevFrame.h != null && prevFrame.h.complexAmps != null && prevFrame.h.complexAmps.length > k) {
                isPrevTrackVoiced = true;
            }
            if (currentFrame != null && currentFrame.h != null && currentFrame.h.complexAmps != null && currentFrame.h.complexAmps.length > k) {
                isTrackVoiced = true;
            }
            if (nextFrame != null && nextFrame.h != null && nextFrame.h.complexAmps != null && nextFrame.h.complexAmps.length > k) {
                isNextTrackVoiced = true;
            }
            tsik = currentFrame.tAnalysisInSeconds;
            double trackStartInSeconds = isFirstSynthesisFrame ? 0.0 : tsik;
            tsikPlusOne = isLastSynthesisFrame || nextFrame == null ? (double)this.hnmSignal.originalDurationInSeconds : (double)nextFrame.tAnalysisInSeconds;
            double trackEndInSeconds = tsikPlusOne;
            if (this.synthesisParams.overlappingHarmonicPartSynthesis) {
                trackStartInSeconds -= (double)this.synthesisParams.harmonicSynthesisOverlapInSeconds;
                trackEndInSeconds += (double)this.synthesisParams.harmonicSynthesisOverlapInSeconds;
            }
            int trackStartIndex = SignalProcUtils.time2sample(trackStartInSeconds, this.hnmSignal.samplingRateInHz);
            int trackEndIndex = SignalProcUtils.time2sample(trackEndInSeconds, this.hnmSignal.samplingRateInHz);
            if (!this.synthesisParams.overlappingHarmonicPartSynthesis) {
                if (!isPrevTrackVoiced) {
                    trackStartIndex -= this.transitionLen;
                }
                if (!isNextTrackVoiced) {
                    trackEndIndex += this.transitionLen;
                }
            }
            Window overlapWin = null;
            double[] overlapWinWgt = null;
            if (this.synthesisParams.overlappingHarmonicPartSynthesis) {
                overlapWin = Window.get(1, trackEndIndex - trackStartIndex + 1);
                overlapWin.normalizePeakValue(1.0f);
                overlapWinWgt = overlapWin.getCoeffs();
            }
            if (!isTrackVoiced || trackEndIndex - trackStartIndex + 1 <= 0) continue;
            if (isTrackVoiced) {
                if (!this.analysisParams.useHarmonicAmplitudesDirectly) {
                    if (this.analysisParams.regularizedCepstrumWarpingMethod == 1) {
                        aksi = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * f0InHz, this.hnmSignal.samplingRateInHz);
                    } else if (this.analysisParams.regularizedCepstrumWarpingMethod == 2) {
                        aksi = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(currentCeps, (float)currentHarmonicNo * f0InHz, this.hnmSignal.samplingRateInHz);
                    }
                } else if (k < currentFrame.h.complexAmps.length) {
                    aksi = MathUtils.magnitudeComplex(currentFrame.h.complexAmps[k]);
                }
            } else {
                aksi = 0.0;
            }
            if (isNextTrackVoiced) {
                if (!this.analysisParams.useHarmonicAmplitudesDirectly) {
                    if (this.analysisParams.regularizedCepstrumWarpingMethod == 1) {
                        aksiPlusOne = RegularizedPreWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(nextCeps, (float)currentHarmonicNo * f0InHzNext, this.hnmSignal.samplingRateInHz);
                    } else if (this.analysisParams.regularizedCepstrumWarpingMethod == 2) {
                        aksiPlusOne = RegularizedPostWarpedCepstrumEstimator.cepstrum2linearSpectrumValue(nextCeps, (float)currentHarmonicNo * f0InHzNext, this.hnmSignal.samplingRateInHz);
                    }
                } else if (k < nextFrame.h.complexAmps.length) {
                    aksiPlusOne = MathUtils.magnitudeComplex(nextFrame.h.complexAmps[k]);
                }
            } else {
                aksiPlusOne = 0.0;
            }
            if (isTrackVoiced) {
                phaseki = currentHarmonicNo == 0 ? 0.0 : MathUtils.phaseInRadians(currentFrame.h.complexAmps[k]);
            }
            if (isNextTrackVoiced) {
                phasekiPlusOne = currentHarmonicNo == 0 ? 0.0 : MathUtils.phaseInRadians(nextFrame.h.complexAmps[k]);
            }
            if (!isTrackVoiced && isNextTrackVoiced) {
                phaseki = (float)(phasekiPlusOne - (double)currentHarmonicNo * (Math.PI * 2) * (double)f0InHzNext * (tsikPlusOne - tsik));
                aksi = 0.0;
            } else if (isTrackVoiced && !isNextTrackVoiced) {
                phasekiPlusOne = phaseki + (double)currentHarmonicNo * (Math.PI * 2) * (double)f0InHz * (tsikPlusOne - tsik);
                aksiPlusOne = 0.0;
            }
            phasekiPlusOneEstimate = phaseki + (double)currentHarmonicNo * (Math.PI * 2) * (double)f0Average * (tsikPlusOne - tsik);
            int Mk = (int)Math.floor((phasekiPlusOneEstimate - phasekiPlusOne) / (Math.PI * 2) + 0.5);
            for (int n = Math.max(0, trackStartIndex); n <= Math.min(trackEndIndex, this.harmonicPart.length - 1); ++n) {
                double currentOverlapWinWgt;
                double t = SignalProcUtils.sample2time(n, this.hnmSignal.samplingRateInHz);
                double akt = t < tsik ? MathUtils.interpolatedSample(tsik - (double)this.synthesisParams.unvoicedVoicedTrackTransitionInSeconds, t, tsik, 0.0, aksi) : (t > tsikPlusOne ? MathUtils.interpolatedSample(tsikPlusOne, t, tsikPlusOne + (double)this.synthesisParams.unvoicedVoicedTrackTransitionInSeconds, aksiPlusOne, 0.0) : MathUtils.interpolatedSample(tsik, t, tsikPlusOne, aksi, aksiPlusOne));
                phasekt = phaseki + (phasekiPlusOne + Math.PI * 2 * (double)Mk - phaseki) * (t - tsik) / (tsikPlusOne - tsik);
                if (this.synthesisParams.overlappingHarmonicPartSynthesis) {
                    currentOverlapWinWgt = overlapWinWgt[n - Math.max(0, trackStartIndex)];
                    double[] dArray = this.winOverlapWgt[k];
                    int n2 = n;
                    dArray[n2] = dArray[n2] + currentOverlapWinWgt;
                } else {
                    currentOverlapWinWgt = 1.0;
                }
                this.harmonicTracks[k][n] = !isPrevTrackVoiced && n - trackStartIndex < this.transitionLen ? currentOverlapWinWgt * this.halfTransitionWinLeft[n - trackStartIndex] * akt * Math.cos(phasekt) : (!isNextTrackVoiced && trackEndIndex - n < this.transitionLen ? currentOverlapWinWgt * this.halfTransitionWinRight[this.transitionLen - (trackEndIndex - n) - 1] * akt * Math.cos(phasekt) : currentOverlapWinWgt * akt * Math.cos(phasekt));
            }
        }
    }

    public double[] generateOutput(boolean pipeOutAllOutput) {
        double[] output = null;
        if (this.harmonicTracks != null) {
            int n;
            int k;
            if (pipeOutAllOutput) {
                this.pipeOutEndIndex = this.harmonicPart.length;
            }
            output = new double[Math.min(this.pipeOutEndIndex, this.harmonicPart.length - 1) - this.pipeOutStartIndex + 1];
            if (!this.synthesisParams.overlappingHarmonicPartSynthesis) {
                for (k = 0; k < this.harmonicTracks.length; ++k) {
                    for (n = this.pipeOutStartIndex; n <= Math.min(this.pipeOutEndIndex, this.harmonicPart.length - 1); ++n) {
                        int n2 = n - this.pipeOutStartIndex;
                        output[n2] = output[n2] + this.harmonicTracks[k][n];
                    }
                }
            } else {
                for (k = 0; k < this.harmonicTracks.length; ++k) {
                    for (n = this.pipeOutStartIndex; n <= Math.min(this.pipeOutEndIndex, this.harmonicPart.length - 1); ++n) {
                        if (this.winOverlapWgt[k][n] > 0.0) {
                            int n3 = n - this.pipeOutStartIndex;
                            output[n3] = output[n3] + this.harmonicTracks[k][n] / this.winOverlapWgt[k][n];
                            continue;
                        }
                        int n4 = n - this.pipeOutStartIndex;
                        output[n4] = output[n4] + this.harmonicTracks[k][n];
                    }
                }
            }
            this.pipeOutStartIndex = this.pipeOutEndIndex + 1;
            if (pipeOutAllOutput && this.referenceFile != null && FileUtils.exists(this.referenceFile) && this.synthesisParams.writeSeparateHarmonicTracksToOutputs) {
                AudioInputStream inputAudio = null;
                try {
                    inputAudio = AudioSystem.getAudioInputStream(new File(this.referenceFile));
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (inputAudio != null) {
                    for (k = 0; k < this.harmonicTracks.length; ++k) {
                        this.harmonicTracks[k] = MathUtils.divide(this.harmonicTracks[k], 32767.0);
                        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(this.harmonicTracks[k]), inputAudio.getFormat());
                        String outFileName = StringUtils.getFolderName(this.referenceFile) + "harmonicTrack" + String.valueOf(k + 1) + ".wav";
                        try {
                            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
                            continue;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return output;
    }
}

