/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.filter.FIRWaveletFilterBankAnalyser;
import marytts.signalproc.filter.FIRWaveletFilterBankSynthesiser;
import marytts.signalproc.filter.Subband;
import marytts.signalproc.sinusoidal.MultiresolutionSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.PeakMatchedSinusoidalSynthesizer;
import marytts.signalproc.sinusoidal.PitchSynchronousSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class MultiresolutionSinusoidalSynthesizer {
    public MultiresolutionSinusoidalAnalyzer analyser;

    public MultiresolutionSinusoidalSynthesizer(MultiresolutionSinusoidalAnalyzer analyserIn) {
        this.analyser = analyserIn;
    }

    public double[] synthesize(SinusoidalTracks[] subbandTracks, boolean isSilentSynthesis) {
        double[] y = null;
        double[] tmpy = null;
        if (subbandTracks != null) {
            if (this.analyser.multiresolutionFilterbankType == 2) {
                Subband[] subbands = new Subband[subbandTracks.length];
                for (int i = 0; i < subbandTracks.length; ++i) {
                    PeakMatchedSinusoidalSynthesizer ss = new PeakMatchedSinusoidalSynthesizer(subbandTracks[i].fs);
                    tmpy = ss.synthesize(subbandTracks[i], isSilentSynthesis);
                    subbands[i] = new Subband(tmpy, subbandTracks[i].fs);
                }
                FIRWaveletFilterBankSynthesiser filterbankSynthesiser = new FIRWaveletFilterBankSynthesiser();
                y = filterbankSynthesiser.apply((FIRWaveletFilterBankAnalyser)this.analyser.filterbankAnalyser, subbands, false);
            } else {
                for (int i = 0; i < subbandTracks.length; ++i) {
                    PeakMatchedSinusoidalSynthesizer ss = new PeakMatchedSinusoidalSynthesizer(subbandTracks[i].fs);
                    tmpy = ss.synthesize(subbandTracks[i], isSilentSynthesis);
                    if (i == 0) {
                        y = new double[tmpy.length];
                        System.arraycopy(tmpy, 0, y, 0, tmpy.length);
                        continue;
                    }
                    for (int j = 0; j < Math.min(y.length, tmpy.length); ++j) {
                        int n = j;
                        y[n] = y[n] + tmpy[j];
                    }
                }
            }
        }
        return y;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int multiresolutionFilterbankType = 2;
        int numBands = 2;
        double lowestBandWindowSizeInSeconds = 0.02;
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        int windowType = 3;
        boolean bRefinePeakEstimatesParabola = false;
        boolean bRefinePeakEstimatesBias = false;
        boolean bSpectralReassignment = false;
        boolean bAdjustNeighFreqDependent = false;
        boolean isSilentSynthesis = false;
        boolean bFreqLimitedAnalysis = false;
        boolean bPitchSynchronous = false;
        float numPeriods = 2.5f;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        MultiresolutionSinusoidalAnalyzer msa = new MultiresolutionSinusoidalAnalyzer(multiresolutionFilterbankType, numBands, samplingRate);
        SinusoidalTracks[] subbandTracks = null;
        if (!bPitchSynchronous) {
            subbandTracks = msa.analyze(x, lowestBandWindowSizeInSeconds, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, bFreqLimitedAnalysis);
        } else {
            String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
            PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
            int pitchMarkOffset = 0;
            PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, samplingRate, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, pitchMarkOffset);
            PitchSynchronousSinusoidalAnalyzer sa = new PitchSynchronousSinusoidalAnalyzer(params);
            subbandTracks = msa.analyze(x, lowestBandWindowSizeInSeconds, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, bFreqLimitedAnalysis, true, pm, numPeriods);
        }
        MultiresolutionSinusoidalSynthesizer mss = new MultiresolutionSinusoidalSynthesizer(msa);
        x = mss.synthesize(subbandTracks, isSilentSynthesis);
        double maxx = MathUtils.getAbsMax(x);
        for (int i = 0; i < x.length; ++i) {
            x[i] = x[i] / maxx * 0.9;
        }
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(x), inputAudio.getFormat());
        String outFileName = args[0].substring(0, args[0].length() - 4) + "_multiResWaveletFixedRate.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
    }
}

