/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.LsfAnalyser;
import marytts.signalproc.filter.HighPassFilter;
import marytts.signalproc.window.HammingWindow;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.FileUtils;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class Blizzard09PostProcessor {
    public static final boolean LABELS_FROM_REALISED_DURATIONS_FILE = true;
    public static final String LABEL_FILE_EXTENSION = ".realised_durations";
    public static final double WINDOW_SIZE_IN_SECONDS_LSF = 0.02;
    public static final double SKIP_SIZE_IN_SECONDS_LSF = 0.005;
    public static final boolean SHARPEN_FORMANTS = true;
    public static final double FORMANT_SHARPENING_START_FREQ = 1000.0;
    public static final double FORMANT_SHARPENING_END_FREQ = 2500.0;
    public static final double RELATIVE_DECREASE_IN_LSF_PAIR_SEPARATION = 15.0;
    public static final double MAX_LSF_PAIR_SEPARATION_IN_HZ = 300.0;
    public static final double WINDOW_SIZE_IN_SECONDS_GAIN = 0.02;
    public static final double SKIP_SIZE_IN_SECONDS_GAIN = 0.001;
    public static final boolean INCREASE_CONSONANT_GAINS = true;
    public static final double CONSONANT_MAX_GAIN_FACTOR = 1.5;
    public static final double CONSONANT_MAX_GAIN_RELATIVE_DURATION = 50.0;
    public static final boolean REDUCE_VOWEL_GAINS = true;
    public static final double VOWEL_MIN_GAIN_FACTOR = 0.7;
    public static final double VOWEL_MIN_GAIN_RELATIVE_DURATION = 50.0;
    public static final boolean APPLY_HIGHPASS_FILTER = false;
    public static final double HIGHPASS_FILTER_CUTOFF = 2000.0;
    public static final double HIGHPASS_FILTER_RELATIVE_GAIN = 0.05;

    public static double[] process(double[] x, Labels labels, Allophone[] allophones, int samplingRateInHz, double absMaxOrig) {
        boolean[] isConsonants = new boolean[labels.items.length];
        boolean[] isVowels = new boolean[labels.items.length];
        boolean[] isPauses = new boolean[labels.items.length];
        block0: for (int i = 0; i < labels.items.length; ++i) {
            int j;
            isConsonants[i] = false;
            int allophoneIndex = -1;
            for (j = 0; j < allophones.length; ++j) {
                if (allophones[j].name().compareTo(labels.items[i].phn) != 0) continue;
                if (!allophones[j].isConsonant() || allophones[j].isPlosive()) break;
                isConsonants[i] = true;
                break;
            }
            isVowels[i] = false;
            allophoneIndex = -1;
            for (j = 0; j < allophones.length; ++j) {
                if (allophones[j].name().compareTo(labels.items[i].phn) != 0) continue;
                if (!allophones[j].isVowel()) break;
                isVowels[i] = true;
                break;
            }
            isPauses[i] = false;
            allophoneIndex = -1;
            for (j = 0; j < allophones.length; ++j) {
                if (allophones[j].name().compareTo(labels.items[i].phn) != 0) continue;
                if (!allophones[j].isPause()) continue block0;
                isPauses[i] = true;
                continue block0;
            }
        }
        double[] y = ArrayUtils.copy(x);
        y = Blizzard09PostProcessor.processLSFs(y, samplingRateInHz, labels, isVowels, isPauses);
        y = Blizzard09PostProcessor.processGains(y, samplingRateInHz, labels, isConsonants, 1.5, 50.0);
        y = Blizzard09PostProcessor.processGains(y, samplingRateInHz, labels, isVowels, 0.7, 50.0);
        double absMaxNew = MathUtils.absMax(y);
        int startIndex = 0;
        for (int i = 0; i < labels.items.length; ++i) {
            if (isPauses[i]) continue;
            int endIndex = SignalProcUtils.time2sample(labels.items[i].time, samplingRateInHz) - 1;
            endIndex = Math.min(endIndex, x.length - 1);
            int j = startIndex;
            while (j <= endIndex) {
                int n = j++;
                y[n] = y[n] * (absMaxOrig / absMaxNew);
            }
            startIndex = endIndex + 1;
        }
        return y;
    }

    public static double[] processGains(double[] x, int samplingRateInHz, Labels labels, boolean[] toBeProcesseds, double extremumGainFactor, double extremumGainRelativeDuration) {
        assert (labels.items.length == toBeProcesseds.length);
        boolean isIncreasing = true;
        if (extremumGainFactor < 1.0) {
            isIncreasing = false;
        }
        double[] y = null;
        double[] w = null;
        int startIndex = 0;
        int ws = SignalProcUtils.time2sample(0.02, samplingRateInHz);
        int ss = SignalProcUtils.time2sample(0.001, samplingRateInHz);
        HammingWindow wfrm = new HammingWindow(ws);
        wfrm.normalizePeakValue(1.0f);
        double[] frmWgt = wfrm.getCoeffs();
        if (x != null && x.length > 0) {
            int i;
            y = new double[x.length];
            w = new double[x.length];
            Arrays.fill(y, 0.0);
            Arrays.fill(w, 0.0);
            double[] frm = new double[ws];
            for (i = 0; i < labels.items.length; ++i) {
                int k;
                boolean bProcessed = false;
                int endIndex = SignalProcUtils.time2sample(labels.items[i].time, samplingRateInHz) - 1;
                int numfrm = (int)Math.floor(((double)((endIndex = Math.min(endIndex, x.length - 1)) - startIndex) + 1.0) / (double)ss + 0.5) + 1;
                if (numfrm > 0) {
                    int windowLen = (int)Math.floor((double)numfrm * (1.0 - extremumGainRelativeDuration / 100.0) + 0.5);
                    double[] wgt = new double[numfrm];
                    if (toBeProcesseds[i]) {
                        Arrays.fill(wgt, extremumGainFactor);
                    } else {
                        Arrays.fill(wgt, 1.0);
                    }
                    if (windowLen > 0 && toBeProcesseds[i]) {
                        int j;
                        HammingWindow wConsonant = new HammingWindow(windowLen);
                        if (isIncreasing) {
                            wConsonant.normalizeRange(1.0f, (float)extremumGainFactor);
                        } else {
                            wConsonant.normalizeRange((float)extremumGainFactor, 1.0f);
                        }
                        double[] lWgt = null;
                        double[] rWgt = null;
                        if (isIncreasing) {
                            lWgt = wConsonant.getCoeffsLeftHalf();
                            rWgt = wConsonant.getCoeffsRightHalf();
                        } else {
                            lWgt = wConsonant.getCoeffsRightHalf();
                            rWgt = wConsonant.getCoeffsLeftHalf();
                        }
                        if (lWgt != null) {
                            for (j = 0; j < lWgt.length; ++j) {
                                wgt[j] = lWgt[j];
                            }
                        }
                        if (rWgt != null) {
                            for (j = 0; j < rWgt.length; ++j) {
                                wgt[j + numfrm - rWgt.length] = rWgt[j];
                            }
                        }
                        for (j = 0; j < numfrm; ++j) {
                            System.arraycopy(x, j * ss + startIndex, frm, 0, Math.min(ws, x.length - (j * ss + startIndex)));
                            for (k = 0; k < Math.min(ws, x.length - (j * ss + startIndex)); ++k) {
                                int n = j * ss + startIndex + k;
                                y[n] = y[n] + x[j * ss + startIndex + k] * frmWgt[k] * wgt[j];
                                int n2 = j * ss + startIndex + k;
                                w[n2] = w[n2] + frmWgt[k];
                            }
                        }
                    } else {
                        HammingWindow wShort = new HammingWindow(endIndex - startIndex + 1);
                        double[] wShortWgt = wShort.getCoeffs();
                        for (k = startIndex; k <= endIndex; ++k) {
                            int n = k;
                            y[n] = y[n] + x[k] * wShortWgt[k - startIndex];
                            int n3 = k;
                            w[n3] = w[n3] + wShortWgt[k - startIndex];
                        }
                    }
                } else {
                    HammingWindow wShort = new HammingWindow(endIndex - startIndex + 1);
                    double[] wShortWgt = wShort.getCoeffs();
                    for (k = startIndex; k <= endIndex; ++k) {
                        int n = k;
                        y[n] = y[n] + x[k] * wShortWgt[k - startIndex];
                        int n4 = k;
                        w[n4] = w[n4] + wShortWgt[k - startIndex];
                    }
                }
                startIndex = endIndex + 1;
            }
            for (i = 0; i < x.length; ++i) {
                if (!(w[i] > 0.0)) continue;
                int n = i;
                y[n] = y[n] / w[i];
            }
        }
        return y;
    }

    public static double[] processLSFs(double[] x, int samplingRateInHz, Labels labels, boolean[] isVowels, boolean[] isPauses) {
        assert (labels.items.length == isVowels.length);
        assert (labels.items.length == isPauses.length);
        double[] y = null;
        double[] w = null;
        int startIndex = 0;
        int ws = SignalProcUtils.time2sample(0.02, samplingRateInHz);
        int ss = SignalProcUtils.time2sample(0.005, samplingRateInHz);
        HammingWindow wfrm = new HammingWindow(ws);
        wfrm.normalizePeakValue(1.0f);
        double[] frmWgt = wfrm.getCoeffs();
        if (x != null && x.length > 0) {
            int i;
            int lpOrder = SignalProcUtils.getLPOrder(samplingRateInHz);
            y = new double[x.length];
            w = new double[x.length];
            Arrays.fill(y, 0.0);
            Arrays.fill(w, 0.0);
            double[] frm = new double[ws];
            int fftSize = SignalProcUtils.getDFTSize(samplingRateInHz);
            for (i = 0; i < labels.items.length; ++i) {
                int k;
                boolean bProcessed = false;
                int endIndex = SignalProcUtils.time2sample(labels.items[i].time + 0.02, samplingRateInHz) - 1;
                int numfrm = (int)Math.floor(((double)(endIndex - startIndex) + 1.0) / (double)ss + 0.5) + 1;
                if (numfrm > 0) {
                    for (int j = 0; j < numfrm; ++j) {
                        Arrays.fill(frm, 0.0);
                        if (j * ss + startIndex >= x.length) continue;
                        System.arraycopy(x, j * ss + startIndex, frm, 0, Math.min(ws, x.length - (j * ss + startIndex)));
                        double[] frmOrig = ArrayUtils.copy(frm);
                        double origEn = SignalProcUtils.energy(frmOrig);
                        wfrm.apply(frm, 0);
                        LpcAnalyser.LpCoeffs lpcs = LpcAnalyser.calcLPC(frm, lpOrder, 0.0f);
                        double[] lsfs = LsfAnalyser.lpc2lsfInHz(lpcs.getOneMinusA(), samplingRateInHz);
                        double[] lsfsMod = ArrayUtils.copy(lsfs);
                        if (isVowels[i]) {
                            double[] dists = new double[lsfs.length - 1];
                            for (k = 0; k < lsfsMod.length - 1; ++k) {
                                dists[k] = lsfs[k + 1] - lsfs[k];
                            }
                            for (k = 1; k < dists.length - 1; ++k) {
                                double shift;
                                double meanFreq;
                                if (dists[k] < Math.min(dists[k + 1], 300.0)) {
                                    meanFreq = 0.5 * (lsfs[k] + lsfs[k + 1]);
                                    if (!(meanFreq >= 1000.0) || !(meanFreq < 2500.0)) continue;
                                    shift = 0.075 * dists[k];
                                    lsfsMod[k] = lsfs[k - 1] + shift;
                                    lsfsMod[k + 1] = lsfs[k - 1] - shift;
                                    k += 2;
                                    continue;
                                }
                                if (!(dists[k + 1] < Math.min(dists[k], 300.0)) || !((meanFreq = 0.5 * (lsfs[k + 1] + lsfs[k + 2])) >= 1000.0) || !(meanFreq < 2500.0)) continue;
                                shift = 0.075 * dists[k];
                                lsfsMod[k + 1] = lsfs[k + 1] + shift;
                                lsfsMod[k + 2] = lsfs[k + 2] - shift;
                                k += 2;
                            }
                        }
                        double[] newOneMinusAs = LsfAnalyser.lsfInHz2lpc(lsfsMod, samplingRateInHz);
                        double[] newLpcs = ArrayUtils.subarray(newOneMinusAs, 1, lpOrder);
                        newLpcs = MathUtils.multiply(newLpcs, -1.0);
                        double[] H2 = LpcAnalyser.calcSpecLinear(lpcs.getA(), lpcs.getGain(), fftSize);
                        double[] HNew = LpcAnalyser.calcSpecLinear(newLpcs, lpcs.getGain(), fftSize);
                        double[] HT = MathUtils.divide(HNew, H2);
                        frm = SignalProcUtils.filterfd(HT, frmOrig, samplingRateInHz);
                        double newEn = SignalProcUtils.energy(frm);
                        double gain = Math.sqrt(origEn) / Math.sqrt(newEn);
                        for (k = 0; k < Math.min(ws, x.length - (j * ss + startIndex)); ++k) {
                            int n = j * ss + startIndex + k;
                            y[n] = y[n] + gain * frm[k] * frmWgt[k];
                            int n2 = j * ss + startIndex + k;
                            w[n2] = w[n2] + frmWgt[k];
                        }
                    }
                } else {
                    HammingWindow wShort = new HammingWindow(endIndex - startIndex + 1);
                    double[] wShortWgt = wShort.getCoeffs();
                    for (k = startIndex; k <= endIndex; ++k) {
                        int n = k;
                        y[n] = y[n] + x[k] * wShortWgt[k - startIndex];
                        int n3 = k;
                        w[n3] = w[n3] + wShortWgt[k - startIndex];
                    }
                }
                startIndex = endIndex - ws;
            }
            for (i = 0; i < x.length; ++i) {
                if (!(w[i] > 0.0)) continue;
                int n = i;
                y[n] = y[n] / w[i];
            }
        }
        return y;
    }

    public static double[] processHigherFormantGains(double[] x, int samplingRateInHz, Labels labels, boolean[] isPauses) {
        assert (labels.items.length == isPauses.length);
        double[] y = null;
        if (x != null && x.length > 0) {
            int i;
            HighPassFilter hpf = new HighPassFilter(2000.0 / (double)samplingRateInHz);
            double[] xhpf = hpf.apply(x);
            for (i = 0; i < x.length; ++i) {
                xhpf[i] = 0.95 * x[i] + 0.05 * xhpf[i];
            }
            y = new double[x.length];
            int startIndex = 0;
            for (i = 0; i < labels.items.length; ++i) {
                int endIndex = SignalProcUtils.time2sample(labels.items[i].time, samplingRateInHz) - 1;
                endIndex = Math.min(endIndex, x.length - 1);
                if (isPauses[i]) {
                    System.arraycopy(x, startIndex, y, startIndex, endIndex - startIndex + 1);
                } else {
                    System.arraycopy(xhpf, startIndex, y, startIndex, endIndex - startIndex + 1);
                }
                startIndex = endIndex + 1;
            }
        }
        return y;
    }

    public static void mainSingleFile(String inputWavFile, String outputWavFile, Allophone[] allophones) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(inputWavFile));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        double absMaxOrig = MathUtils.absMax(x);
        String strLabFile = StringUtils.modifyExtension(inputWavFile, LABEL_FILE_EXTENSION);
        if (!FileUtils.exists(strLabFile)) {
            System.out.println("Label file not found: " + strLabFile + "...skipping...");
        } else {
            Labels labels = new Labels(strLabFile);
            double[] y = Blizzard09PostProcessor.process(x, labels, allophones, samplingRate, absMaxOrig);
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(y), inputAudio.getFormat());
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outputWavFile));
        }
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        if (args.length < 3) {
            System.out.println("Missing parameters:");
            System.out.println("<input wav file or directory> <output wav file or directory> <full path of phone set file>");
            System.out.println("Example phone set file: .../lib/modules/en/us/lexicon/allophones.en_US.xml");
        } else {
            String phoneSetFile = args[2];
            AllophoneSet allophoneSet = AllophoneSet.getAllophoneSet(phoneSetFile);
            Set<String> tmpPhonemes = allophoneSet.getAllophoneNames();
            int count = 0;
            Allophone[] allophones = new Allophone[tmpPhonemes.size()];
            Iterator<String> it = tmpPhonemes.iterator();
            while (it.hasNext()) {
                allophones[count] = allophoneSet.getAllophone(it.next());
                if (++count < tmpPhonemes.size()) continue;
            }
            if (FileUtils.isDirectory(args[0])) {
                if (!FileUtils.exists(args[1])) {
                    FileUtils.createDirectory(args[1]);
                }
                String[] fileList = FileUtils.getFileList(args[0], "wav");
                String outputFolder = StringUtils.checkLastSlash(args[1]);
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        String baseFileName = StringUtils.getFileName(fileList[i], true);
                        String outputFile = outputFolder + baseFileName + ".wav";
                        Blizzard09PostProcessor.mainSingleFile(fileList[i], outputFile, allophones);
                        System.out.println("Processing completed for file " + String.valueOf(i + 1) + " of " + String.valueOf(fileList.length));
                    }
                } else {
                    System.out.println("No wav files found!");
                }
            } else {
                Blizzard09PostProcessor.mainSingleFile(args[0], args[1], allophones);
            }
            System.out.println("Processing completed...");
        }
    }
}

