/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.SignalSpectrum;
import marytts.util.math.MathUtils;

public class LogSpectrum
extends SignalSpectrum {
    public LogSpectrum(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public LogSpectrum(AudioInputStream ais, int width, int height) {
        super(ais, width, height);
    }

    public LogSpectrum(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public LogSpectrum(double[] signal, int samplingRate, int width, int height) {
        super(signal, samplingRate, width, height);
    }

    @Override
    protected void process(double[] freqs) {
        for (int i = 0; i < freqs.length; ++i) {
            freqs[i] = MathUtils.db(freqs[i] * freqs[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            LogSpectrum signalSpectrum = new LogSpectrum(ais);
            signalSpectrum.showInJFrame(args[i], true, false);
        }
    }
}

