/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Color;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.F0TrackerAutocorrelationHeuristic;
import marytts.signalproc.analysis.PitchFileHeader;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;

public class F0Graph
extends FunctionGraph {
    public F0Graph(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public F0Graph(AudioInputStream ais, int width, int height) {
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        this.initialise(signal, signal.getSamplingRate(), width, height);
    }

    public F0Graph(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public F0Graph(double[] signal, int samplingRate, int width, int height) {
        this.initialise(new BufferedDoubleDataSource(signal), samplingRate, width, height);
    }

    protected void initialise(DoubleDataSource signal, int samplingRate, int width, int height) {
        PitchFileHeader params = new PitchFileHeader();
        params.fs = samplingRate;
        F0TrackerAutocorrelationHeuristic tracker = new F0TrackerAutocorrelationHeuristic(params);
        tracker.pitchAnalyze(signal);
        double frameShiftTime = tracker.getSkipSizeInSeconds();
        double[] f0Array = tracker.getF0Contour();
        double xOffset = tracker.getWindowSizeInSeconds() / 2.0;
        super.initialise(width, height, xOffset, frameShiftTime, f0Array);
        this.setPrimaryDataSeriesStyle(Color.RED, 2, 3);
        this.dotSize = 8;
    }

    public static void main(String[] args) throws Exception {
        AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[0]));
        F0Graph f0Graph = new F0Graph(ais);
        f0Graph.showInJFrame(args[0], true, true);
    }
}

