/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import marytts.signalproc.analysis.LsfAnalyser;
import marytts.signalproc.analysis.LsfFileHeader;

public class Lsfs {
    public double[][] lsfs;
    public LsfFileHeader params;

    public Lsfs() {
        this.lsfs = null;
        this.params = new LsfFileHeader();
    }

    public Lsfs(String lsfFile) throws IOException {
        this.readLsfFile(lsfFile);
    }

    public void readLsfFile(String lsfFile) throws IOException {
        DataInputStream stream;
        this.lsfs = null;
        this.params = new LsfFileHeader();
        if (!lsfFile.equals("") && (stream = this.params.readHeader(lsfFile, true)) != null) {
            this.lsfs = LsfAnalyser.readLsfs(stream, this.params);
        }
    }

    public void writeLsfFile(String lsfFile) {
        if (lsfFile != "") {
            DataOutputStream stream = null;
            try {
                stream = this.params.writeHeader(lsfFile, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stream != null) {
                try {
                    LsfAnalyser.writeLsfs(stream, this.lsfs);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void allocate() {
        this.allocate(this.params.numfrm, this.params.dimension);
    }

    public void allocate(int numEntries, int dimension) {
        this.lsfs = null;
        this.params.numfrm = 0;
        this.params.dimension = 0;
        if (numEntries > 0) {
            this.lsfs = new double[numEntries][];
            this.params.numfrm = numEntries;
            if (dimension > 0) {
                this.params.dimension = dimension;
                for (int i = 0; i < numEntries; ++i) {
                    this.lsfs[i] = new double[dimension];
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Lsfs l1 = new Lsfs();
        l1.params.dimension = 5;
        l1.params.numfrm = 1;
        l1.allocate();
        l1.lsfs[0][0] = 1.5;
        l1.lsfs[0][1] = 2.5;
        l1.lsfs[0][2] = 3.5;
        l1.lsfs[0][3] = 4.5;
        l1.lsfs[0][4] = 5.5;
        String lsfFile = "d:/1.lsf";
        l1.writeLsfFile(lsfFile);
        Lsfs l2 = new Lsfs(lsfFile);
        System.out.println("Test of class Lsfs completed...");
    }
}

