/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import java.util.Locale;

public class Label {
    public double time;
    public int status;
    public String phn;
    public double ll;
    public String[] rest;
    public double[] valuesRest;

    public Label(double endTime, String phoneSymbol) {
        this(endTime, 125, phoneSymbol, Double.NEGATIVE_INFINITY, null, null);
    }

    public Label(double newTime, int newStatus, String newPhn, double newll) {
        this(newTime, newStatus, newPhn, newll, null, null);
    }

    public Label() {
        this(-1.0, 0, "", Double.NEGATIVE_INFINITY, null, null);
    }

    public Label(double newTime, int newStatus, String newPhn, double newll, String[] restIn) {
        this(newTime, newStatus, newPhn, newll, restIn, null);
    }

    public Label(double newTime, int newStatus, String newPhn, double newll, String[] restIn, double[] valuesRestIn) {
        int i;
        this.time = newTime;
        this.status = newStatus;
        this.phn = newPhn;
        this.ll = newll;
        if (restIn != null && restIn.length > 0) {
            this.rest = new String[restIn.length];
            for (i = 0; i < restIn.length; ++i) {
                this.rest[i] = restIn[i];
            }
        } else {
            this.rest = null;
        }
        if (valuesRestIn != null && valuesRestIn.length > 0) {
            this.valuesRest = new double[valuesRestIn.length];
            for (i = 0; i < valuesRestIn.length; ++i) {
                this.valuesRest[i] = valuesRestIn[i];
            }
        } else {
            this.valuesRest = null;
        }
    }

    public Label(Label lab) {
        if (lab != null) {
            this.copyFrom(lab);
        }
    }

    public void copyFrom(Label lab) {
        int i;
        this.time = lab.time;
        this.status = lab.status;
        this.phn = lab.phn;
        this.ll = lab.ll;
        if (lab.rest != null && lab.rest.length > 0) {
            this.rest = new String[lab.rest.length];
            for (i = 0; i < lab.rest.length; ++i) {
                this.rest[i] = lab.rest[i];
            }
        } else {
            this.rest = null;
        }
        if (lab.valuesRest != null && lab.valuesRest.length > 0) {
            this.valuesRest = new double[lab.valuesRest.length];
            for (i = 0; i < lab.valuesRest.length; ++i) {
                this.valuesRest[i] = lab.valuesRest[i];
            }
        } else {
            this.valuesRest = null;
        }
    }

    public void print() {
        System.out.println("Time=" + String.valueOf(this.time) + " s. " + "Stat=" + String.valueOf(this.status) + " " + "Phone=" + this.phn + " " + "Log-likelihood=" + String.valueOf(this.ll));
    }

    public String toString() {
        return String.format(Locale.US, "%f %d %s %f", this.time, this.status, this.phn, this.ll);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Label)) {
            return false;
        }
        Label other = (Label)o;
        return Math.abs(this.time - other.time) < 1.0E-7 && this.status == other.status && (this.phn == null && other.phn == null || this.phn != null && this.phn.equals(other.phn)) && (this.ll == other.ll || Double.isInfinite(this.ll) && Double.isInfinite(other.ll) || Double.isNaN(this.ll) && Double.isNaN(other.ll)) && Arrays.deepEquals(this.rest, other.rest);
    }

    public int hashCode() {
        return 0;
    }
}

