/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.ArrayList;
import marytts.signalproc.process.FrameProvider;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;

public abstract class FrameBasedAnalyser<T>
extends FrameProvider {
    protected FrameAnalysisResult<T>[] analysisResults;

    public FrameBasedAnalyser(DoubleDataSource signal, Window window, int frameShift, int samplingRate) {
        super(signal, window, window.getLength(), frameShift, samplingRate, true);
    }

    public FrameAnalysisResult<T> analyseNextFrame() {
        double[] frame = this.getNextFrame();
        if (frame == null) {
            return null;
        }
        T analysisResult = this.analyse(frame);
        return this.constructAnalysisResult(analysisResult);
    }

    public FrameAnalysisResult<T>[] analyseAllFrames() {
        if (this.analysisResults == null) {
            FrameAnalysisResult<T> oneResult;
            ArrayList<FrameAnalysisResult<T>> results = new ArrayList<FrameAnalysisResult<T>>();
            while ((oneResult = this.analyseNextFrame()) != null) {
                results.add(oneResult);
            }
            FrameAnalysisResult[] arr = new FrameAnalysisResult[results.size()];
            this.analysisResults = results.toArray(arr);
        }
        return this.analysisResults;
    }

    public FrameAnalysisResult<T>[] analyseAvailableFrames() {
        ArrayList<FrameAnalysisResult<T>> results = new ArrayList<FrameAnalysisResult<T>>();
        while (this.signal.available() >= this.frameLength) {
            FrameAnalysisResult<T> oneResult = this.analyseNextFrame();
            assert (oneResult != null);
            results.add(oneResult);
        }
        FrameAnalysisResult[] arr = new FrameAnalysisResult[results.size()];
        return results.toArray(arr);
    }

    public abstract T analyse(double[] var1);

    protected FrameAnalysisResult<T> constructAnalysisResult(T analysisResult) {
        return new FrameAnalysisResult<T>(this.frame, this.getFrameStartTime(), analysisResult);
    }

    public static class FrameAnalysisResult<T> {
        protected double[] windowedSignal;
        protected double startTime;
        protected T analysisResult;

        protected FrameAnalysisResult(double[] windowedSignal, double startTime, T analysisResult) {
            this.windowedSignal = new double[windowedSignal.length];
            System.arraycopy(windowedSignal, 0, this.windowedSignal, 0, windowedSignal.length);
            this.startTime = startTime;
            this.analysisResult = analysisResult;
        }

        public double[] getWindowedSignal() {
            return this.windowedSignal;
        }

        public double getStartTime() {
            return this.startTime;
        }

        public T get() {
            return this.analysisResult;
        }
    }
}

