/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTrainerParams;
import marytts.signalproc.adaptation.outlier.GMMOutlierEliminator;
import marytts.signalproc.adaptation.outlier.GaussianOutlierEliminator;
import marytts.signalproc.adaptation.outlier.KMeansMappingEliminator;
import marytts.util.io.FileUtils;

public class WeightedCodebookOutlierEliminator {
    private GaussianOutlierEliminator gaussian;
    private KMeansMappingEliminator kmeans;
    private GMMOutlierEliminator gmm;

    public void run(WeightedCodebookTrainerParams params) {
        String tempIn = params.temporaryCodebookFile;
        String tempOut = params.temporaryCodebookFile + "2";
        if (!(params.gaussianEliminatorParams.isCheckDurationOutliers || params.gaussianEliminatorParams.isCheckEnergyOutliers || params.gaussianEliminatorParams.isCheckF0Outliers || params.gaussianEliminatorParams.isCheckLsfOutliers)) {
            params.gaussianEliminatorParams.isActive = false;
        }
        if (!(params.kmeansEliminatorParams.isCheckDurationOutliers || params.kmeansEliminatorParams.isCheckEnergyOutliers || params.kmeansEliminatorParams.isCheckF0Outliers || params.kmeansEliminatorParams.isCheckLsfOutliers)) {
            params.kmeansEliminatorParams.isActive = false;
        }
        if (params.gaussianEliminatorParams.isActive) {
            if (!params.kmeansEliminatorParams.isActive) {
                tempOut = params.codebookFile;
            }
            this.gaussian = new GaussianOutlierEliminator();
            if (params.codebookHeader.vocalTractFeature != BaselineFeatureExtractor.LSF_FEATURES) {
                params.gaussianEliminatorParams.isCheckLsfOutliers = false;
            }
            this.gaussian.eliminate(params.gaussianEliminatorParams, tempIn, tempOut);
        }
        if (params.kmeansEliminatorParams.isActive) {
            if (params.gaussianEliminatorParams.isActive) {
                tempIn = tempOut;
            }
            tempOut = params.codebookFile;
            this.kmeans = new KMeansMappingEliminator();
            if (params.codebookHeader.vocalTractFeature != BaselineFeatureExtractor.LSF_FEATURES) {
                params.kmeansEliminatorParams.isCheckLsfOutliers = false;
            }
            this.kmeans.eliminate(params.kmeansEliminatorParams, tempIn, tempOut);
            if (params.gaussianEliminatorParams.isActive) {
                FileUtils.delete(tempIn);
            }
        }
        if (!params.gaussianEliminatorParams.isActive && !params.kmeansEliminatorParams.isActive) {
            FileUtils.rename(tempIn, params.codebookFile);
        }
    }
}

