/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import marytts.datatypes.MaryDataType;
import marytts.modules.synthesis.Voice;
import marytts.server.Request;
import marytts.server.RequestHandler;
import marytts.server.http.AudioStreamNHttpEntity;
import marytts.server.http.BaseHttpRequestHandler;
import marytts.server.http.MaryHttpServerUtils;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AppendableSequenceAudioInputStream;
import marytts.util.data.audio.MaryAudioUtils;
import marytts.util.http.Address;
import org.apache.http.HttpResponse;
import org.apache.log4j.Logger;

public class SynthesisRequestHandler
extends BaseHttpRequestHandler {
    private static int id = 0;
    private RequestHandler.StreamingOutputWriter outputToStream = null;
    private RequestHandler.StreamingOutputPiper streamToPipe = null;
    private PipedOutputStream pipedOutput = null;
    private PipedInputStream pipedInput = null;

    private static synchronized int getId() {
        return id++;
    }

    @Override
    protected void handleClientRequest(String absPath, Map<String, String> queryItems, HttpResponse response, Address serverAddressAtClient) throws IOException {
        logger.debug("New synthesis request: " + absPath);
        if (queryItems != null) {
            for (String key : queryItems.keySet()) {
                logger.debug("    " + key + "=" + queryItems.get(key));
            }
        }
        this.process(serverAddressAtClient, queryItems, response);
    }

    public void process(Address serverAddressAtClient, Map<String, String> queryItems, HttpResponse response) {
        String message;
        String effects;
        String style;
        if (!(queryItems != null && queryItems.containsKey("INPUT_TYPE") && queryItems.containsKey("OUTPUT_TYPE") && queryItems.containsKey("LOCALE") && queryItems.containsKey("INPUT_TEXT"))) {
            MaryHttpServerUtils.errorMissingQueryParameter(response, "'INPUT_TEXT' and 'INPUT_TYPE' and 'OUTPUT_TYPE' and 'LOCALE'");
            return;
        }
        String inputText = queryItems.get("INPUT_TEXT");
        MaryDataType inputType = MaryDataType.get(queryItems.get("INPUT_TYPE"));
        if (inputType == null) {
            MaryHttpServerUtils.errorWrongQueryParameterValue(response, "INPUT_TYPE", queryItems.get("INPUT_TYPE"), null);
            return;
        }
        MaryDataType outputType = MaryDataType.get(queryItems.get("OUTPUT_TYPE"));
        if (outputType == null) {
            MaryHttpServerUtils.errorWrongQueryParameterValue(response, "OUTPUT_TYPE", queryItems.get("OUTPUT_TYPE"), null);
            return;
        }
        boolean isOutputText = true;
        boolean streamingAudio = false;
        AudioFileFormat.Type audioFileFormatType = null;
        if (outputType.name().contains("AUDIO")) {
            int lastUnderscore;
            isOutputText = false;
            String audioTypeName = queryItems.get("AUDIO");
            if (audioTypeName == null) {
                MaryHttpServerUtils.errorMissingQueryParameter(response, "'AUDIO' when OUTPUT_TYPE=AUDIO");
                return;
            }
            if (audioTypeName.endsWith("_STREAM")) {
                streamingAudio = true;
            }
            if ((lastUnderscore = audioTypeName.lastIndexOf(95)) != -1) {
                audioTypeName = audioTypeName.substring(0, lastUnderscore);
            }
            try {
                audioFileFormatType = MaryAudioUtils.getAudioFileFormatType(audioTypeName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (audioFileFormatType == null) {
                MaryHttpServerUtils.errorWrongQueryParameterValue(response, "AUDIO", queryItems.get("AUDIO"), null);
                return;
            }
            if (audioFileFormatType.toString().equals("MP3") && !MaryRuntimeUtils.canCreateMP3()) {
                MaryHttpServerUtils.errorWrongQueryParameterValue(response, "AUDIO", queryItems.get("AUDIO"), "Conversion to MP3 not supported.");
                return;
            }
            if (audioFileFormatType.toString().equals("Vorbis") && !MaryRuntimeUtils.canCreateOgg()) {
                MaryHttpServerUtils.errorWrongQueryParameterValue(response, "AUDIO", queryItems.get("AUDIO"), "Conversion to OGG Vorbis format not supported.");
                return;
            }
        }
        String outputTypeParams = queryItems.get("OUTPUT_TYPE_PARAMS");
        Locale locale = MaryUtils.string2locale(queryItems.get("LOCALE"));
        if (locale == null) {
            MaryHttpServerUtils.errorWrongQueryParameterValue(response, "LOCALE", queryItems.get("LOCALE"), null);
            return;
        }
        Voice voice = null;
        String voiceName = queryItems.get("VOICE");
        if (voiceName != null && (voice = voiceName.equals("male") || voiceName.equals("female") ? Voice.getVoice(locale, new Voice.Gender(voiceName)) : Voice.getVoice(voiceName)) == null) {
            MaryHttpServerUtils.errorWrongQueryParameterValue(response, "VOICE", queryItems.get("VOICE"), null);
            return;
        }
        if (voice == null) {
            voice = Voice.getDefaultVoice(locale);
            logger.debug("No voice requested -- using default " + voice);
        }
        if ((style = queryItems.get("STYLE")) == null) {
            style = "";
        }
        if ((effects = this.toRequestedAudioEffectsString(queryItems)).length() > 0) {
            logger.debug("Audio effects requested: " + effects);
        } else {
            logger.debug("No audio effects requested");
        }
        String logMsg = queryItems.get("LOG");
        if (logMsg != null) {
            logger.info("Connection info: " + logMsg);
        }
        if (audioFileFormatType == null) {
            audioFileFormatType = AudioFileFormat.Type.AU;
        }
        AudioFormat audioFormat = audioFileFormatType.toString().equals("MP3") ? MaryRuntimeUtils.getMP3AudioFormat() : (audioFileFormatType.toString().equals("Vorbis") ? MaryRuntimeUtils.getOggAudioFormat() : (voice != null ? voice.dbAudioFormat() : Voice.AF16000));
        AudioFileFormat audioFileFormat = new AudioFileFormat(audioFileFormatType, audioFormat, -1);
        final Request maryRequest = new Request(inputType, outputType, locale, voice, effects, style, SynthesisRequestHandler.getId(), audioFileFormat, streamingAudio, outputTypeParams);
        boolean ok = true;
        try {
            maryRequest.setInputData(inputText);
            logger.info("Read: " + inputText);
        }
        catch (Exception e) {
            message = "Problem reading input";
            logger.warn(message, e);
            MaryHttpServerUtils.errorInternalServerError(response, message, e);
            ok = false;
        }
        if (ok) {
            if (streamingAudio) {
                new Thread("RH " + maryRequest.getId()){

                    @Override
                    public void run() {
                        Logger myLogger = MaryUtils.getLogger(this.getName());
                        try {
                            maryRequest.process();
                            myLogger.info("Streaming request processed successfully.");
                        }
                        catch (Throwable t) {
                            myLogger.error("Processing failed.", t);
                        }
                    }
                }.start();
                AppendableSequenceAudioInputStream audio = maryRequest.getAudio();
                assert (audio != null) : "Streaming audio but no audio stream -- very strange indeed! :-(";
                AudioFileFormat.Type audioType = maryRequest.getAudioFileFormat().getType();
                AudioStreamNHttpEntity entity = new AudioStreamNHttpEntity(maryRequest);
                new Thread((Runnable)entity, "HTTPWriter " + maryRequest.getId()).start();
                response.setEntity(entity);
                response.setStatusCode(200);
                return;
            }
            try {
                maryRequest.process();
            }
            catch (Throwable e) {
                message = "Processing failed.";
                logger.error(message, e);
                MaryHttpServerUtils.errorInternalServerError(response, message, e);
                ok = false;
            }
            if (ok) {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    maryRequest.writeOutputData(outputStream);
                    String contentType = maryRequest.getOutputType().isXMLType() || maryRequest.getOutputType().isTextType() ? "text/plain; charset=UTF-8" : MaryHttpServerUtils.getMimeType(maryRequest.getAudioFileFormat().getType());
                    MaryHttpServerUtils.toHttpResponse(outputStream.toByteArray(), response, contentType);
                }
                catch (Exception e) {
                    message = "Cannot write output";
                    logger.warn(message, e);
                    MaryHttpServerUtils.errorInternalServerError(response, message, e);
                    ok = false;
                }
            }
        }
        if (ok) {
            logger.info("Request handled successfully.");
        } else {
            logger.info("Request couldn't be handled successfully.");
        }
        if (MaryRuntimeUtils.lowMemoryCondition()) {
            logger.info("Low memory condition detected (only " + MaryUtils.availableMemory() + " bytes left). Triggering garbage collection.");
            Runtime.getRuntime().gc();
            logger.info("After garbage collection: " + MaryUtils.availableMemory() + " bytes available.");
        }
    }

    protected String toRequestedAudioEffectsString(Map<String, String> keyValuePairs) {
        StringBuilder effects = new StringBuilder();
        Set<String> keys = keyValuePairs.keySet();
        for (String currentKey : keys) {
            StringTokenizer tt;
            if (!currentKey.startsWith("effect_") || !currentKey.endsWith("_selected") || keyValuePairs.get(currentKey).compareTo("on") != 0) continue;
            if (effects.length() > 0) {
                effects.append("+");
            }
            if ((tt = new StringTokenizer(currentKey, "_")).hasMoreTokens()) {
                tt.nextToken();
            }
            if (!tt.hasMoreTokens()) continue;
            String currentEffectName = tt.nextToken();
            String currentEffectParams = keyValuePairs.get("effect_" + currentEffectName + "_parameters");
            if (currentEffectParams != null && currentEffectParams.length() > 0) {
                effects.append(currentEffectName).append("(").append(currentEffectParams).append(")");
                continue;
            }
            effects.append(currentEffectName);
        }
        return effects.toString();
    }
}

