/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.phonemiser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class Allophone {
    private String name;
    private final Map<String, String> features;

    public Allophone(Element a, String[] featureNames) {
        String isTone;
        String vc;
        this.name = a.getAttribute("ph");
        if (this.name.equals("")) {
            throw new IllegalArgumentException("Element must have a 'ph' attribute");
        }
        if (a.getTagName().equals("consonant")) {
            vc = "-";
            isTone = "-";
        } else if (a.getTagName().equals("vowel")) {
            vc = "+";
            isTone = "-";
        } else if (a.getTagName().equals("silence")) {
            vc = "0";
            isTone = "-";
        } else if (a.getTagName().equals("tone")) {
            vc = "0";
            isTone = "+";
        } else {
            throw new IllegalArgumentException("Element must be one of <vowel>, <consonant> and <silence>, but is <" + a.getTagName() + ">");
        }
        HashMap<String, String> feats = new HashMap<String, String>();
        feats.put("vc", vc);
        feats.put("isTone", isTone);
        for (String f : featureNames) {
            feats.put(f, this.getAttribute(a, f));
        }
        this.features = Collections.unmodifiableMap(feats);
    }

    private String getAttribute(Element e, String att) {
        String val = e.getAttribute(att);
        if (val.equals("")) {
            return "0";
        }
        return val;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean isVowel() {
        return "+".equals(this.features.get("vc"));
    }

    public boolean isDiphthong() {
        assert (this.isVowel());
        return "d".equals(this.features.get("vlng"));
    }

    public boolean isSyllabic() {
        return this.isVowel();
    }

    public boolean isConsonant() {
        return "-".equals(this.features.get("vc"));
    }

    public boolean isVoiced() {
        return this.isVowel() || "+".equals(this.features.get("cvox"));
    }

    public boolean isSonorant() {
        return "lnr".contains(this.features.get("ctype"));
    }

    public boolean isLiquid() {
        return "l".equals(this.features.get("ctype"));
    }

    public boolean isNasal() {
        return "n".equals(this.features.get("ctype"));
    }

    public boolean isGlide() {
        return "r".equals(this.features.get("ctype")) && !this.isVowel();
    }

    public boolean isFricative() {
        return "f".equals(this.features.get("ctype"));
    }

    public boolean isPlosive() {
        return "s".equals(this.features.get("ctype"));
    }

    public boolean isAffricate() {
        return "a".equals(this.features.get("ctype"));
    }

    public boolean isPause() {
        return "0".equals(this.features.get("vc")) && "-".equals(this.features.get("isTone"));
    }

    public boolean isTone() {
        return "+".equals(this.features.get("isTone"));
    }

    public int sonority() {
        if (this.isVowel()) {
            String vlng = this.features.get("vlng");
            if (vlng == null) {
                return 5;
            }
            if ("ld".contains(vlng)) {
                return 6;
            }
            if ("s".equals(vlng)) {
                return 5;
            }
            if ("a".equals(vlng)) {
                return 4;
            }
            return 5;
        }
        if (this.isSonorant()) {
            return 3;
        }
        if (this.isFricative()) {
            return 2;
        }
        return 1;
    }

    public Map<String, String> getFeatures() {
        return this.features;
    }

    public String getFeature(String feat) {
        return this.features.get(feat);
    }
}

