/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.acoustic;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureVector;
import marytts.htsengine.CartTreeSet;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSModel;
import marytts.htsengine.HTSParameterGeneration;
import marytts.htsengine.HTSUttModel;
import marytts.modules.acoustic.Model;
import marytts.unitselection.select.Target;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class HMMModel
extends Model {
    private HMMData htsData = null;
    private CartTreeSet cart;
    FeatureDefinition hmmFeatureDefinition;
    private float fperiodsec;
    protected static Logger logger = MaryUtils.getLogger("HMMModel");
    private boolean predictDurAndF0 = false;
    private Map<List<Element>, HTSUttModel> uttModels = new WeakHashMap<List<Element>, HTSUttModel>();

    public HMMModel(FeatureProcessorManager featureManager, String voiceName, InputStream dataStream, String targetAttributeName, String targetAttributeFormat, String featureName, String predictFrom, String applyTo) throws MaryConfigurationException {
        super(featureManager, voiceName, dataStream, targetAttributeName, targetAttributeFormat, featureName, predictFrom, applyTo);
        if (!targetAttributeName.contentEquals("d") && !targetAttributeName.contentEquals("f0")) {
            throw new MaryConfigurationException("targetAttributeName = " + targetAttributeName + " Not known");
        }
        this.load();
    }

    public void setPredictDurAndF0(boolean bval) {
        this.predictDurAndF0 = bval;
    }

    @Override
    protected void loadData() throws IOException, MaryConfigurationException {
        if (this.htsData == null) {
            this.htsData = new HMMData();
        }
        this.htsData.initHMMDataForHMMModel(this.voiceName);
        this.cart = this.htsData.getCartTreeSet();
        this.fperiodsec = (float)this.htsData.getFperiod() / (float)this.htsData.getRate();
        this.predictionFeatureNames = this.htsData.getFeatureDefinition().getFeatureNames();
    }

    @Override
    public void applyTo(List<Element> elements) throws MaryConfigurationException {
        logger.debug("predicting duration");
        HTSUttModel um = this.predictAndSetDuration(elements, elements);
        if (this.predictDurAndF0) {
            this.uttModels.put(elements, um);
        }
    }

    @Override
    public void applyFromTo(List<Element> predictFromElements, List<Element> applyToElements) throws MaryConfigurationException {
        HTSUttModel um;
        logger.debug("predicting F0");
        if (this.predictDurAndF0) {
            logger.debug("using already created utterance model, it contains predicted state durations.");
            um = this.uttModels.get(applyToElements);
        } else {
            logger.debug("creating utterance model with equal values for state durations.");
            um = this.createUttModel(predictFromElements);
        }
        assert (um != null);
        this.predictAndSetF0(applyToElements, um);
    }

    private HTSUttModel predictAndSetDuration(List<Element> predictFromElements, List<Element> applyToElements) throws MaryConfigurationException {
        List<Element> predictorElements = predictFromElements;
        List<Target> predictorTargets = this.getTargets(predictorElements);
        FeatureVector fv = null;
        HTSUttModel um = new HTSUttModel();
        FeatureDefinition feaDef = this.htsData.getFeatureDefinition();
        double diffdurOld = 0.0;
        double diffdurNew = 0.0;
        String durAttributeName = "d";
        try {
            for (int i = 0; i < predictorTargets.size(); ++i) {
                fv = predictorTargets.get(i).getFeatureVector();
                um.addUttModel(new HTSModel(this.cart.getNumStates()));
                HTSModel m = um.getUttModel(i);
                m.setPhoneName(fv.getFeatureAsString(feaDef.getFeatureIndex("phone"), feaDef));
                if (this.htsData.getUseContextDependentGV() && m.getPhoneName().contentEquals("_")) {
                    m.setGvSwitch(false);
                }
                um.setNumModel(um.getNumModel() + 1);
                um.setNumState(um.getNumState() + this.cart.getNumStates());
                diffdurOld = diffdurNew = this.cart.searchDurInCartTree(m, fv, this.htsData, diffdurOld);
                double duration = (float)m.getTotalDur() * this.fperiodsec;
                um.setTotalFrame(um.getTotalFrame() + m.getTotalDur());
                this.cart.searchLf0InCartTree(m, fv, feaDef, this.htsData.getUV());
                for (int mstate = 0; mstate < this.cart.getNumStates(); ++mstate) {
                    for (int frame = 0; frame < m.getDur(mstate); ++frame) {
                        if (!m.getVoiced(mstate)) continue;
                        um.setLf0Frame(um.getLf0Frame() + 1);
                    }
                }
                Element element = applyToElements.get(i);
                if (durAttributeName.startsWith("@")) {
                    durAttributeName = durAttributeName.replaceFirst("@", "");
                }
                String formattedTargetValue = String.format(this.targetAttributeFormat, duration);
                if (element.hasAttribute(durAttributeName)) {
                    formattedTargetValue = element.getAttribute(durAttributeName) + " " + formattedTargetValue;
                }
                element.setAttribute(durAttributeName, formattedTargetValue);
            }
            return um;
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Error searching in tree when predicting duration. ", e);
        }
    }

    private void predictAndSetF0(List<Element> applyToElements, HTSUttModel um) throws MaryConfigurationException {
        try {
            String f0AttributeName = "f0";
            HTSParameterGeneration pdf2par = new HTSParameterGeneration();
            boolean debug = false;
            pdf2par.htsMaximumLikelihoodParameterGeneration(um, this.htsData);
            boolean[] voiced = pdf2par.getVoicedArray();
            int numVoiced = 0;
            assert (applyToElements.size() == um.getNumModel());
            int t = 0;
            for (int i = 0; i < applyToElements.size(); ++i) {
                HTSModel m = um.getUttModel(i);
                int k = 1;
                int numVoicedInModel = m.getNumVoiced();
                String formattedTargetValue = "";
                for (int mstate = 0; mstate < this.cart.getNumStates(); ++mstate) {
                    for (int frame = 0; frame < m.getDur(mstate); ++frame) {
                        if (!voiced[t++]) continue;
                        float f0 = (float)Math.exp(pdf2par.getlf0Pst().getPar(numVoiced++, 0));
                        formattedTargetValue = formattedTargetValue + "(" + Integer.toString((int)((double)k * 100.0 / (double)numVoicedInModel)) + "," + Integer.toString((int)f0) + ")";
                        ++k;
                    }
                }
                Element element = applyToElements.get(i);
                if (f0AttributeName.startsWith("@")) {
                    f0AttributeName = f0AttributeName.replaceFirst("@", "");
                }
                if (formattedTargetValue.length() <= 0) continue;
                element.setAttribute(f0AttributeName, formattedTargetValue);
            }
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Error generating F0 out of HMMs trees and pdfs. ", e);
        }
    }

    private HTSUttModel createUttModel(List<Element> predictFromElements) throws MaryConfigurationException {
        List<Element> predictorElements = predictFromElements;
        List<Target> predictorTargets = this.getTargets(predictorElements);
        HTSUttModel um = new HTSUttModel();
        FeatureDefinition feaDef = this.htsData.getFeatureDefinition();
        double diffdurOld = 0.0;
        double diffdurNew = 0.0;
        Object f0s = null;
        try {
            for (int i = 0; i < predictorTargets.size(); ++i) {
                FeatureVector fv = predictorTargets.get(i).getFeatureVector();
                Element e = predictFromElements.get(i);
                um.addUttModel(new HTSModel(this.cart.getNumStates()));
                HTSModel m = um.getUttModel(i);
                m.setPhoneName(fv.getFeatureAsString(feaDef.getFeatureIndex("phone"), feaDef));
                if (this.htsData.getUseContextDependentGV() && m.getPhoneName().contentEquals("_")) {
                    m.setGvSwitch(false);
                }
                um.setNumModel(um.getNumModel() + 1);
                um.setNumState(um.getNumState() + this.cart.getNumStates());
                float duration = (float)Integer.parseInt(e.getAttribute("d")) * 0.001f;
                int durInFrames = (int)(duration / this.fperiodsec);
                int durStateInFrames = durInFrames / this.cart.getNumStates();
                m.setTotalDur(0);
                for (int s = 0; s < this.cart.getNumStates(); ++s) {
                    m.setDur(s, durStateInFrames);
                    m.setTotalDur(m.getTotalDur() + m.getDur(s));
                }
                um.setTotalFrame(um.getTotalFrame() + m.getTotalDur());
                System.out.format("createUttModel: duration=%.3f sec. durInFrames=%d  durStateInFrames=%d  m.getTotalDur()=%d\n", Float.valueOf(duration), durInFrames, durStateInFrames, m.getTotalDur());
                this.cart.searchLf0InCartTree(m, fv, feaDef, this.htsData.getUV());
                for (int mstate = 0; mstate < this.cart.getNumStates(); ++mstate) {
                    for (int frame = 0; frame < m.getDur(mstate); ++frame) {
                        if (!m.getVoiced(mstate)) continue;
                        um.setLf0Frame(um.getLf0Frame() + 1);
                    }
                }
            }
            return um;
        }
        catch (Exception e) {
            throw new MaryConfigurationException("Error searching in tree when creating utterance model. ", e);
        }
    }

    @Override
    protected float evaluate(Target target) {
        throw new RuntimeException("This method should never be called");
    }
}

