/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import marytts.datatypes.MaryDataType;
import marytts.fst.FSTLookup;
import marytts.modules.ProsodyGeneric;

public class ProsodyGenericFST
extends ProsodyGeneric {
    public ProsodyGenericFST(MaryDataType inputType, MaryDataType outputType, Locale locale, String tobipredFileName, String accentPriorities, String syllableAccents, String paragraphDeclination) throws IOException {
        super(inputType, outputType, locale, tobipredFileName, accentPriorities, syllableAccents, paragraphDeclination);
    }

    @Override
    protected Object readListFromResource(String resourceName) throws IOException {
        String suffix = resourceName.substring(resourceName.length() - 4, resourceName.length());
        if (suffix.equals(".fst")) {
            InputStream resourceStream = this.getClass().getResourceAsStream("prosody/" + resourceName);
            return new FSTLookup(resourceStream, resourceName, "ISO-8859-1");
        }
        return super.readListFromResource(resourceName);
    }

    @Override
    protected boolean checkList(String currentVal, String tokenValue) {
        boolean contains;
        if (currentVal == null || tokenValue == null) {
            throw new NullPointerException("Received null argument");
        }
        if (!currentVal.startsWith("INLIST") && !currentVal.startsWith("!INLIST")) {
            throw new IllegalArgumentException("currentVal does not start with INLIST or !INLIST");
        }
        boolean negation = currentVal.startsWith("!");
        String listName = currentVal.substring(currentVal.indexOf(":") + 1);
        Object listObj = this.listMap.get(listName);
        if (listObj == null) {
            return false;
        }
        if (listObj instanceof Set) {
            Set set = (Set)listObj;
            contains = set.contains(tokenValue);
        } else if (listObj instanceof FSTLookup) {
            FSTLookup fst = (FSTLookup)listObj;
            contains = fst.lookup(tokenValue).length > 0;
        } else {
            throw new IllegalArgumentException("Unknown list representation: " + listObj);
        }
        return (!contains || !negation) && (contains || negation);
    }
}

