/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import marytts.machinelearning.GMMTrainerParams;

public class KMeansClusteringTrainerParams {
    public static final int KMEANS_MAX_ITERATIONS_DEFAULT = 200;
    public static final double KMEANS_MIN_CLUSTER_CHANGE_PERCENT_DEFAULT = 1.0E-4;
    public static final boolean KMEANS_IS_DIAGONAL_COVARIANCE_DEFAULT = true;
    public static final int KMEANS_MIN_SAMPLES_IN_ONE_CLUSTER_DEFAULT = 10;
    private static final double KMEANS_MIN_COVARIANCE_ALLOWED_DEFAULT = 1.0E-5;
    public int numClusters;
    public int maxIterations;
    public double minClusterChangePercent;
    public boolean isDiagonalOutputCovariance;
    public int minSamplesInOneCluster;
    public double minCovarianceAllowed;
    public double[] globalVariances;

    public KMeansClusteringTrainerParams() {
        this.numClusters = 0;
        this.maxIterations = 200;
        this.minClusterChangePercent = 1.0E-4;
        this.isDiagonalOutputCovariance = true;
        this.minSamplesInOneCluster = 10;
        this.minCovarianceAllowed = 1.0E-5;
        this.globalVariances = null;
    }

    public KMeansClusteringTrainerParams(GMMTrainerParams gmmParams) {
        this.numClusters = gmmParams.totalComponents;
        this.maxIterations = gmmParams.kmeansMaxIterations;
        this.minClusterChangePercent = gmmParams.kmeansMinClusterChangePercent;
        this.isDiagonalOutputCovariance = gmmParams.isDiagonalCovariance;
        this.minSamplesInOneCluster = gmmParams.kmeansMinSamplesInOneCluster;
        this.minCovarianceAllowed = gmmParams.minCovarianceAllowed;
        this.globalVariances = null;
    }

    public KMeansClusteringTrainerParams(KMeansClusteringTrainerParams existing) {
        this.numClusters = existing.numClusters;
        this.maxIterations = existing.maxIterations;
        this.minClusterChangePercent = existing.minClusterChangePercent;
        this.isDiagonalOutputCovariance = existing.isDiagonalOutputCovariance;
        this.minSamplesInOneCluster = existing.minSamplesInOneCluster;
        this.setGlobalVariances(existing.globalVariances);
    }

    public void setGlobalVariances(double[] globalVariancesIn) {
        if (globalVariancesIn != null) {
            if (this.globalVariances == null || globalVariancesIn.length != this.globalVariances.length) {
                this.globalVariances = new double[globalVariancesIn.length];
            }
            System.arraycopy(globalVariancesIn, 0, this.globalVariances, 0, globalVariancesIn.length);
        }
    }
}

