/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import java.util.Arrays;
import marytts.util.math.MathUtils;

public class ClusteredDataGenerator {
    public static final int DEFAULT_NUM_SAMPLES_IN_CLUSTERS = 50;
    public static final int DEFAULT_NUM_CLUSTERS = 10;
    public static final double DEFAULT_INIT_MEAN = 10.0;
    public static final double DEFAULT_VARIANCE = 1.0;
    public double[] data;

    public ClusteredDataGenerator() {
        double[] clusterMeans = new double[10];
        for (int i = 0; i < 10; ++i) {
            clusterMeans[i] = (double)(i + 1) * 10.0;
        }
        this.init(clusterMeans);
    }

    public ClusteredDataGenerator(int numClusters, int numSamplesInClusters) {
        this(numClusters, numSamplesInClusters, 10.0);
    }

    public ClusteredDataGenerator(int numClusters, int numSamplesInClusters, double initMean) {
        this(numClusters, numSamplesInClusters, initMean, 1.0);
    }

    public ClusteredDataGenerator(int numClusters, int numSamplesInClusters, double initMean, double variance) {
        double[] clusterMeans = new double[numClusters];
        for (int i = 0; i < numClusters; ++i) {
            clusterMeans[i] = (double)(i + 1) * initMean;
        }
        this.init(clusterMeans, variance, numSamplesInClusters);
    }

    public ClusteredDataGenerator(double[] clusterMeans) {
        this(clusterMeans, 1.0);
    }

    public ClusteredDataGenerator(double[] clusterMeans, double variance) {
        this.init(clusterMeans, variance);
    }

    public ClusteredDataGenerator(double[] clusterMeans, double[] variances) {
        this.init(clusterMeans, variances, 50);
    }

    public ClusteredDataGenerator(double[] clusterMeans, double[] variances, int numSamplesPerCluster) {
        this.init(clusterMeans, variances, numSamplesPerCluster);
    }

    public void init(double[] clusterMeans) {
        this.init(clusterMeans, 1.0);
    }

    public void init(double[] clusterMeans, double variance) {
        this.init(clusterMeans, variance, 50);
    }

    public void init(double[] clusterMeans, double variance, int numClusters) {
        double[] variances = new double[clusterMeans.length];
        Arrays.fill(variances, variance);
        this.init(clusterMeans, variances, numClusters);
    }

    public void init(double[] clusterMeans, double[] variances, int numSamplesPerCluster) {
        this.data = new double[numSamplesPerCluster * clusterMeans.length];
        for (int i = 0; i < clusterMeans.length; ++i) {
            double[] tmp = MathUtils.random(numSamplesPerCluster);
            MathUtils.adjustMean(tmp, clusterMeans[i]);
            MathUtils.adjustVariance(tmp, variances[i]);
            System.arraycopy(tmp, 0, this.data, i * numSamplesPerCluster, numSamplesPerCluster);
            System.out.println("Target mean=" + String.valueOf(clusterMeans[i]) + " Target variance=" + String.valueOf(variances[i]) + " - Mean=" + String.valueOf(MathUtils.mean(tmp)) + " Variance=" + String.valueOf(MathUtils.variance(tmp)));
        }
        double m = MathUtils.mean(this.data);
        double v = MathUtils.variance(this.data, m);
        System.out.println(String.valueOf(m) + " " + String.valueOf(v));
    }

    public static void main(String[] args) {
        ClusteredDataGenerator c = new ClusteredDataGenerator();
    }
}

