/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en_US;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import marytts.datatypes.MaryData;
import marytts.language.en.Segmenter;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.server.MaryProperties;

public class FreeTTSSegmenter
extends InternalModule {
    private UtteranceProcessor processor;
    private static Map<String, String> mrpa2sampa;

    public FreeTTSSegmenter() {
        super("Segmenter", USEnglishDataTypes.FREETTS_POS, USEnglishDataTypes.FREETTS_SEGMENTS, Locale.US);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
        this.processor = new Segmenter();
        mrpa2sampa = new HashMap<String, String>();
        this.fillSampaMap();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processor.processUtterance(utterance);
            Relation segs = utterance.getRelation("Segment");
            for (Item s = segs.getHead(); s != null; s = s.getNext()) {
                String mrpa = s.getFeatures().getString("name");
                String sampa = FreeTTSSegmenter.mrpa2sampa(mrpa);
                s.getFeatures().setString("name", sampa);
            }
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fillSampaMap() throws Exception {
        String sampamapFilename = MaryProperties.needFilename("english.freetts.lexicon.sampamapfile");
        if (sampamapFilename == null) return;
        this.logger.debug("For FreeTTSSegmenter, filling sampa map from file " + sampamapFilename);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sampamapFilename), "UTF-8"));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                try {
                    this.addSampaMapEntry(line);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Ignoring invalid entry in sampa map file " + sampamapFilename, iae);
                    return;
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Cannot open file '" + sampamapFilename + "'", ioe);
        }
    }

    private void addSampaMapEntry(String entry) throws IllegalArgumentException {
        boolean s2v = false;
        boolean v2s = false;
        String[] parts = null;
        if ((entry = entry.replace('+', ' ')).indexOf("<->") != -1) {
            parts = entry.split("<->");
            s2v = true;
            v2s = true;
        } else if (entry.indexOf("->") != -1) {
            parts = entry.split("->");
            s2v = true;
        } else if (entry.indexOf("<-") != -1) {
            parts = entry.split("<-");
            v2s = true;
        }
        if (parts == null || parts.length != 2) {
            throw new IllegalArgumentException();
        }
        if (v2s) {
            mrpa2sampa.put(parts[1].trim(), parts[0].trim());
        }
    }

    public static String mrpa2sampa(String voicePhoneme) {
        if (mrpa2sampa.containsKey(voicePhoneme)) {
            return mrpa2sampa.get(voicePhoneme);
        }
        return voicePhoneme;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            ((Segmenter)this.processor).saveAddenda();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.logger.warn("Could not save addenda");
        }
    }
}

