/*
 * Decompiled with CFR 0.152.
 */
package marytts.fst;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class FST {
    int[] targets;
    short[] labels;
    boolean[] isLast;
    short[] offsets;
    byte[] bytes;
    int[] mapping;
    ArrayList strings = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FST(String fileName) throws IOException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            this.load(fis);
        }
    }

    public FST(InputStream inStream) throws IOException {
        this.load(inStream);
    }

    public FST(String fileName, String encoding) throws IOException, UnsupportedEncodingException {
        this(fileName, encoding, false);
    }

    public FST(String fileName, boolean verbose) throws IOException {
        this(fileName, null, verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FST(String fileName, String encoding, boolean verbose) throws IOException, UnsupportedEncodingException {
        try (FileInputStream fis = new FileInputStream(fileName);){
            this.loadHeaderless(fis, encoding, verbose);
        }
    }

    public FST(InputStream inStream, String encoding) throws IOException, UnsupportedEncodingException {
        this.loadHeaderless(inStream, encoding, false);
    }

    private void load(InputStream inStream) throws IOException, UnsupportedEncodingException {
        int i;
        DataInputStream in = new DataInputStream(new BufferedInputStream(inStream));
        int fileSize = in.available();
        int encLen = in.readInt();
        byte[] encBytes = new byte[encLen];
        in.read(encBytes, 0, encLen);
        String encoding = new String(encBytes, "UTF-8");
        if (!Charset.isSupported(encoding)) {
            throw new IOException("Encoding of FST file not correctly specified. Maybe file in old format.");
        }
        int overallBits = in.readInt();
        int arcOffBits = in.readInt();
        if (overallBits != 32 || arcOffBits != 20) {
            throw new IOException("Cannot handle non-standard bit allocation for label and arc id's.");
        }
        int nArcs = in.readInt();
        this.targets = new int[nArcs];
        this.labels = new short[nArcs];
        this.isLast = new boolean[nArcs];
        for (i = 0; i < nArcs; ++i) {
            int thisArc = in.readInt();
            this.targets[i] = thisArc & 0xFFFFF;
            this.labels[i] = (short)(thisArc >> 20 & 0x7FF);
            this.isLast[i] = (byte)(thisArc >> 31) != 0;
        }
        int nPairs = in.readInt();
        this.offsets = new short[2 * nPairs];
        for (i = 0; i < 2 * nPairs; ++i) {
            this.offsets[i] = in.readShort();
        }
        int nBytes = fileSize - 20 - encLen - 4 * (nPairs + nArcs);
        this.mapping = new int[nBytes];
        this.bytes = new byte[nBytes];
        in.readFully(this.bytes);
        assert (in.available() == 0) : "Partial file read... not good";
        in.close();
        this.createMapping(this.mapping, this.bytes, encoding);
    }

    private void loadHeaderless(InputStream inStream, String encoding, boolean verbose) throws IOException, UnsupportedEncodingException {
        int i;
        DataInputStream in = new DataInputStream(new BufferedInputStream(inStream));
        int fileSize = in.available();
        int nArcs = in.readInt();
        this.targets = new int[nArcs];
        this.labels = new short[nArcs];
        this.isLast = new boolean[nArcs];
        for (i = 0; i < nArcs; ++i) {
            int thisArc = in.readInt();
            this.targets[i] = thisArc & 0xFFFFF;
            this.labels[i] = (short)(thisArc >> 20 & 0x7FF);
            this.isLast[i] = (byte)(thisArc >> 31) != 0;
        }
        int nPairs = in.readInt();
        this.offsets = new short[2 * nPairs];
        for (i = 0; i < 2 * nPairs; ++i) {
            this.offsets[i] = in.readShort();
        }
        int nBytes = fileSize - 8 - 4 * (nPairs + nArcs);
        this.mapping = new int[nBytes];
        this.bytes = new byte[nBytes];
        in.readFully(this.bytes);
        if (verbose) {
            System.err.println("FST (" + fileSize + " Bytes, " + nArcs + " Arcs, " + nPairs + " Labels)" + " loaded");
        }
        in.close();
        this.createMapping(this.mapping, this.bytes, encoding);
    }

    private void createMapping(int[] mapping, byte[] bytes, String encoding) throws UnsupportedEncodingException {
        mapping[0] = 0;
        int last0 = -1;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            int len = i - last0 - 1;
            if (len == 0) {
                this.strings.add("");
            } else {
                String str = encoding != null ? new String(bytes, last0 + 1, len, encoding) : new String(bytes, last0 + 1, len);
                this.strings.add(str);
            }
            mapping[last0 + 1] = this.strings.size() - 1;
            last0 = i;
        }
    }
}

