/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import marytts.features.ByteValuedFeatureProcessor;
import marytts.features.ContinuousFeatureProcessor;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureVector;
import marytts.features.MaryFeatureProcessor;
import marytts.features.MaryLanguageFeatureProcessors;
import marytts.features.ShortValuedFeatureProcessor;
import marytts.unitselection.select.Target;

public class TargetFeatureComputer {
    protected ByteValuedFeatureProcessor[] byteValuedDiscreteFeatureProcessors;
    protected ShortValuedFeatureProcessor[] shortValuedDiscreteFeatureProcessors;
    protected ContinuousFeatureProcessor[] continuousFeatureProcessors;
    protected String pauseSymbol = null;
    protected FeatureDefinition featureDefinition = null;

    public TargetFeatureComputer(FeatureProcessorManager manager, String featureProcessorNames) {
        ArrayList<MaryFeatureProcessor> byteValuedFeatureProcessors = new ArrayList<MaryFeatureProcessor>();
        ArrayList<MaryFeatureProcessor> shortValuedFeatureProcessors = new ArrayList<MaryFeatureProcessor>();
        ArrayList<MaryFeatureProcessor> continuousValuedFeatureProcessors = new ArrayList<MaryFeatureProcessor>();
        StringTokenizer st = new StringTokenizer(featureProcessorNames);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            MaryFeatureProcessor fp = manager.getFeatureProcessor(name);
            if (fp == null) {
                throw new IllegalArgumentException("Unknown feature processor: " + name);
            }
            if (fp instanceof ByteValuedFeatureProcessor) {
                byteValuedFeatureProcessors.add(fp);
                continue;
            }
            if (fp instanceof ShortValuedFeatureProcessor) {
                shortValuedFeatureProcessors.add(fp);
                continue;
            }
            if (fp instanceof ContinuousFeatureProcessor) {
                continuousValuedFeatureProcessors.add(fp);
                continue;
            }
            throw new IllegalArgumentException("Unknown feature processor type " + fp.getClass() + " for feature processor: " + name);
        }
        this.byteValuedDiscreteFeatureProcessors = byteValuedFeatureProcessors.toArray(new ByteValuedFeatureProcessor[0]);
        this.shortValuedDiscreteFeatureProcessors = shortValuedFeatureProcessors.toArray(new ShortValuedFeatureProcessor[0]);
        this.continuousFeatureProcessors = continuousValuedFeatureProcessors.toArray(new ContinuousFeatureProcessor[0]);
    }

    public FeatureDefinition getFeatureDefinition() {
        if (this.featureDefinition == null) {
            String[] values;
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("ByteValuedFeatureProcessors").append("\n");
            for (i = 0; i < this.byteValuedDiscreteFeatureProcessors.length; ++i) {
                sb.append(this.byteValuedDiscreteFeatureProcessors[i].getName());
                for (String v : values = this.byteValuedDiscreteFeatureProcessors[i].getValues()) {
                    sb.append(" ").append(v);
                }
                sb.append("\n");
            }
            sb.append("ShortValuedFeatureProcessors").append("\n");
            for (i = 0; i < this.shortValuedDiscreteFeatureProcessors.length; ++i) {
                sb.append(this.shortValuedDiscreteFeatureProcessors[i].getName());
                for (String v : values = this.shortValuedDiscreteFeatureProcessors[i].getValues()) {
                    sb.append(" ").append(v);
                }
                sb.append("\n");
            }
            sb.append("ContinuousFeatureProcessors").append("\n");
            for (i = 0; i < this.continuousFeatureProcessors.length; ++i) {
                sb.append(this.continuousFeatureProcessors[i].getName()).append("\n");
            }
            BufferedReader reader = new BufferedReader(new StringReader(sb.toString()));
            try {
                this.featureDefinition = new FeatureDefinition(reader, false);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem creating feature definition", e);
            }
        }
        return this.featureDefinition;
    }

    public FeatureVector computeFeatureVector(Target target) {
        int i;
        byte[] byteFeatures = new byte[this.byteValuedDiscreteFeatureProcessors.length];
        short[] shortFeatures = new short[this.shortValuedDiscreteFeatureProcessors.length];
        float[] floatFeatures = new float[this.continuousFeatureProcessors.length];
        for (i = 0; i < this.byteValuedDiscreteFeatureProcessors.length; ++i) {
            byteFeatures[i] = this.byteValuedDiscreteFeatureProcessors[i].process(target);
        }
        for (i = 0; i < this.shortValuedDiscreteFeatureProcessors.length; ++i) {
            shortFeatures[i] = this.shortValuedDiscreteFeatureProcessors[i].process(target);
        }
        for (i = 0; i < this.continuousFeatureProcessors.length; ++i) {
            floatFeatures[i] = this.continuousFeatureProcessors[i].process(target);
        }
        return new FeatureVector(byteFeatures, shortFeatures, floatFeatures, 0);
    }

    public String toStringValues(FeatureVector features) {
        int i;
        StringBuilder buf = new StringBuilder();
        byte[] bytes = features.getByteValuedDiscreteFeatures();
        short[] shorts = features.getShortValuedDiscreteFeatures();
        float[] floats = features.getContinuousFeatures();
        if (bytes.length != this.byteValuedDiscreteFeatureProcessors.length || shorts.length != this.shortValuedDiscreteFeatureProcessors.length || floats.length != this.continuousFeatureProcessors.length) {
            throw new IllegalArgumentException("Number of features in argument does not match number of feature processors");
        }
        for (i = 0; i < bytes.length; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.byteValuedDiscreteFeatureProcessors[i].getValues()[bytes[i] & 0xFF]);
        }
        for (i = 0; i < shorts.length; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.shortValuedDiscreteFeatureProcessors[i].getValues()[shorts[i]]);
        }
        for (i = 0; i < floats.length; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(floats[i]);
        }
        return buf.toString();
    }

    public ByteValuedFeatureProcessor[] getByteValuedFeatureProcessors() {
        return this.byteValuedDiscreteFeatureProcessors;
    }

    public ShortValuedFeatureProcessor[] getShortValuedFeatureProcessors() {
        return this.shortValuedDiscreteFeatureProcessors;
    }

    public ContinuousFeatureProcessor[] getContinuousFeatureProcessors() {
        return this.continuousFeatureProcessors;
    }

    public String getAllFeatureProcessorNames() {
        return "ByteValuedFeatureProcessors " + this.getByteValuedFeatureProcessorNames() + "\n" + "ShortValuedFeatureProcessors " + this.getShortValuedFeatureProcessorNames() + "\n" + "ContinuousFeatureProcessors " + this.getContinuousFeatureProcessorNames() + "\n";
    }

    public String getByteValuedFeatureProcessorNames() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.byteValuedDiscreteFeatureProcessors.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.byteValuedDiscreteFeatureProcessors[i].getName());
        }
        return buf.toString();
    }

    public String getShortValuedFeatureProcessorNames() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.shortValuedDiscreteFeatureProcessors.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.shortValuedDiscreteFeatureProcessors[i].getName());
        }
        return buf.toString();
    }

    public String getContinuousFeatureProcessorNames() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.continuousFeatureProcessors.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.continuousFeatureProcessors[i].getName());
        }
        return buf.toString();
    }

    public String getAllFeatureProcessorNamesAndValues() {
        return "ByteValuedFeatureProcessors\n" + this.getByteValuedFeatureProcessorNamesAndValues() + "ShortValuedFeatureProcessors" + "\n" + this.getShortValuedFeatureProcessorNamesAndValues() + "ContinuousFeatureProcessors" + "\n" + this.getContinuousFeatureProcessorNamesAndValues();
    }

    public String getByteValuedFeatureProcessorNamesAndValues() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.byteValuedDiscreteFeatureProcessors.length; ++i) {
            buf.append(this.byteValuedDiscreteFeatureProcessors[i].getName());
            String[] values = this.byteValuedDiscreteFeatureProcessors[i].getValues();
            for (int j = 0; j < values.length; ++j) {
                buf.append(" ");
                buf.append(values[j]);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getShortValuedFeatureProcessorNamesAndValues() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.shortValuedDiscreteFeatureProcessors.length; ++i) {
            buf.append(this.shortValuedDiscreteFeatureProcessors[i].getName());
            String[] values = this.shortValuedDiscreteFeatureProcessors[i].getValues();
            for (int j = 0; j < values.length; ++j) {
                buf.append(" ");
                buf.append(values[j]);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public String getContinuousFeatureProcessorNamesAndValues() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.continuousFeatureProcessors.length; ++i) {
            buf.append(this.continuousFeatureProcessors[i].getName());
            buf.append(" float\n");
        }
        return buf.toString();
    }

    public String getPauseSymbol() {
        if (this.pauseSymbol == null) {
            for (ByteValuedFeatureProcessor fp : this.byteValuedDiscreteFeatureProcessors) {
                if (!(fp instanceof MaryLanguageFeatureProcessors.Phone)) continue;
                this.pauseSymbol = ((MaryLanguageFeatureProcessors.Phone)fp).getPauseSymbol();
                break;
            }
        }
        return this.pauseSymbol;
    }
}

