/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import marytts.client.AudioEffectControlGUI;
import marytts.client.AudioEffectsBoxData;

public class AudioEffectsBoxGUI {
    private AudioEffectsBoxData data;
    public AudioEffectControlGUI[] effectControls;
    public JPanel mainPanel;
    public JLabel effectsBoxLabel;
    public JScrollPane scrollPane;
    public JPanel effectControlsPanel;

    public AudioEffectsBoxGUI(String availableEffects) {
        this.data = new AudioEffectsBoxData(availableEffects);
        if (availableEffects != null && !availableEffects.equals("")) {
            this.mainPanel = new JPanel();
            this.effectsBoxLabel = new JLabel("Audio Effects:");
            this.effectControlsPanel = new JPanel();
            if (this.data.getTotalEffects() > 0) {
                this.effectControls = new AudioEffectControlGUI[this.data.getTotalEffects()];
                for (int i = 0; i < this.effectControls.length; ++i) {
                    this.effectControls[i] = new AudioEffectControlGUI(this.data.getControlData(i));
                }
            } else {
                this.effectControls = null;
            }
        } else {
            this.effectControls = null;
        }
    }

    public AudioEffectsBoxData getData() {
        return this.data;
    }

    public boolean hasEffects() {
        return this.data.hasEffects();
    }

    public void show() {
        this.mainPanel.removeAll();
        this.mainPanel.validate();
        this.effectControlsPanel.removeAll();
        this.effectControlsPanel.validate();
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.mainPanel.setLayout(g);
        c.fill = 3;
        g.setConstraints(this.mainPanel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.ipadx = 200;
        c.ipady = 20;
        c.fill = 10;
        g.setConstraints(this.effectsBoxLabel, c);
        this.mainPanel.add(this.effectsBoxLabel);
        c.gridx = 0;
        c.gridy = 1;
        c.ipadx = 0;
        c.ipady = 0;
        g.setConstraints(this.effectControlsPanel, c);
        this.mainPanel.add(this.effectControlsPanel);
        if (this.effectControls != null && this.effectControls.length > 0) {
            this.effectControlsPanel.setLayout(g);
            c.gridx = 0;
            c.fill = 1;
            int totalShown = 0;
            for (int i = 0; i < this.effectControls.length; ++i) {
                if (!this.effectControls[i].getVisible()) continue;
                c.gridy = totalShown++;
                g.setConstraints(this.effectControls[i].mainPanel, c);
                this.effectControlsPanel.add(this.effectControls[i].mainPanel);
                this.effectControls[i].show();
            }
        }
        c.gridx = 0;
        c.gridy = 1;
        c.ipadx = 300;
        c.ipady = 105;
        this.scrollPane = new JScrollPane(this.effectControlsPanel);
        this.scrollPane.setViewportView(this.effectControlsPanel);
        g.setConstraints(this.scrollPane, c);
        this.mainPanel.add(this.scrollPane);
        this.effectControlsPanel.validate();
        this.mainPanel.validate();
    }
}

