/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.freetts.de;

import com.sun.speech.freetts.VoiceManager;
import com.sun.speech.freetts.lexicon.LexiconImpl;
import com.sun.speech.freetts.util.BulkTimer;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class GermanLexicon
extends LexiconImpl {
    static /* synthetic */ Class class$de$dfki$lt$freetts$de$GermanLexicon;

    public GermanLexicon(URL compiledURL, URL addendaURL, URL letterToSoundURL, boolean binary) {
        this.setLexiconParameters(compiledURL, addendaURL, letterToSoundURL, binary);
    }

    public GermanLexicon() {
        this("germanlex");
    }

    public GermanLexicon(String basename) {
        this(basename, true);
    }

    public GermanLexicon(String basename, boolean useBinaryIO) {
        URLClassLoader classLoader = VoiceManager.getVoiceClassLoader();
        String type = useBinaryIO ? "bin" : "txt";
        URL letterToSoundURL = classLoader.getResource("de/dfki/lt/freetts/de/" + basename + "_lts." + type);
        URL compiledURL = classLoader.getResource("de/dfki/lt/freetts/de/" + basename + "_compiled." + type);
        URL addendaURL = classLoader.getResource("de/dfki/lt/freetts/de/" + basename + "_addenda." + type);
        if (letterToSoundURL == null) {
            Class cls = class$de$dfki$lt$freetts$de$GermanLexicon == null ? (class$de$dfki$lt$freetts$de$GermanLexicon = GermanLexicon.class$("de.dfki.lt.freetts.de.GermanLexicon")) : class$de$dfki$lt$freetts$de$GermanLexicon;
            letterToSoundURL = cls.getResource(basename + "_lts." + type);
            compiledURL = cls.getResource(basename + "_compiled." + type);
            addendaURL = cls.getResource(basename + "_addenda." + type);
            if (letterToSoundURL == null) {
                System.err.println("GermanLexicon: Oh no!  Couldn't find lexicon data!");
            }
        }
        this.setLexiconParameters(compiledURL, addendaURL, letterToSoundURL, useBinaryIO);
    }

    public static GermanLexicon getInstance(boolean useBinaryIO) throws IOException {
        return GermanLexicon.getInstance("dummylex", useBinaryIO);
    }

    public static GermanLexicon getInstance(String basename, boolean useBinaryIO) throws IOException {
        GermanLexicon lexicon = new GermanLexicon(basename, useBinaryIO);
        lexicon.load();
        return lexicon;
    }

    public boolean isSyllableBoundary(List syllablePhones, String[] wordPhones, int currentWordPhone) {
        return false;
    }

    public static void main(String[] args) {
        boolean showTimes = false;
        String srcPath = ".";
        String destPath = ".";
        String baseName = "germanlex";
        try {
            if (args.length > 0) {
                BulkTimer.LOAD.start();
                int i = 0;
                while (i < args.length) {
                    GermanLexicon lex;
                    if (args[i].equals("-src")) {
                        srcPath = args[++i];
                    } else if (args[i].equals("-dest")) {
                        destPath = args[++i];
                    } else if (args[i].equals("-name") && i < args.length - 1) {
                        baseName = args[++i];
                    } else if (args[i].equals("-generate_binary")) {
                        System.out.println("Loading " + baseName);
                        String path = "file:" + srcPath + "/" + baseName;
                        lex = new GermanLexicon(new URL(path + "_compiled.txt"), new URL(path + "_addenda.txt"), new URL(path + "_lts.txt"), false);
                        BulkTimer.LOAD.start("load_text");
                        lex.load();
                        BulkTimer.LOAD.stop("load_text");
                        System.out.println("Dumping " + baseName);
                        BulkTimer.LOAD.start("dump_text");
                        lex.dumpBinary(destPath + "/" + baseName);
                        BulkTimer.LOAD.stop("dump_text");
                    } else if (args[i].equals("-compare")) {
                        BulkTimer.LOAD.start("load_text");
                        lex = GermanLexicon.getInstance(baseName, false);
                        BulkTimer.LOAD.stop("load_text");
                        BulkTimer.LOAD.start("load_binary");
                        GermanLexicon lex2 = GermanLexicon.getInstance(baseName, true);
                        BulkTimer.LOAD.stop("load_binary");
                        BulkTimer.LOAD.start("compare");
                        lex.compare(lex2);
                        BulkTimer.LOAD.stop("compare");
                    } else if (args[i].equals("-showtimes")) {
                        showTimes = true;
                    } else {
                        System.out.println("Unknown option " + args[i]);
                    }
                    ++i;
                }
                BulkTimer.LOAD.stop();
                if (showTimes) {
                    BulkTimer.LOAD.show("GermanLexicon loading and dumping");
                }
            } else {
                System.out.println("Options: ");
                System.out.println("    -src path");
                System.out.println("    -dest path");
                System.out.println("    -compare");
                System.out.println("    -generate_binary");
                System.out.println("    -showtimes");
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

