/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.relp;

import com.sun.speech.freetts.relp.Sample;
import com.sun.speech.freetts.relp.SampleInfo;
import com.sun.speech.freetts.relp.SampleSet;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MappedSampleSet
extends SampleSet {
    private Sample[] samples;
    private SampleInfo sampleInfo;
    private int samplesStart;
    private int sampleSize;
    private int frameSize;
    private int residualSize;
    private ByteBuffer bb;
    private int[] residualSizes;

    public MappedSampleSet(ByteBuffer bb) throws IOException {
        this.bb = bb;
        this.sampleInfo = new SampleInfo(bb);
        int numSamples = bb.getInt();
        this.frameSize = bb.getInt();
        this.residualSize = bb.getInt();
        this.residualSizes = new int[numSamples];
        this.samplesStart = bb.position();
        this.sampleSize = 8 + this.frameSize * 2 + this.residualSize;
        int lastPosition = this.samplesStart + 4 + this.frameSize * 2;
        bb.position(lastPosition);
        for (int i = 0; i < numSamples; ++i) {
            this.residualSizes[i] = bb.getInt();
            bb.position(lastPosition += this.sampleSize);
        }
        int newPosition = this.samplesStart + numSamples * this.sampleSize;
        bb.position(newPosition);
    }

    public Sample getSample(int index) {
        try {
            int start = this.samplesStart + this.sampleSize * index + 4;
            int startRes = start + this.frameSize * 2 + 4;
            Sample sample = new Sample(this.bb, start, startRes, this.residualSizes[index], this.frameSize);
            return sample;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Error building sample " + index);
        }
    }

    public SampleInfo getSampleInfo() {
        return this.sampleInfo;
    }

    public int getUnitSize(int start, int end) {
        int size = 0;
        for (int i = start; i < end; ++i) {
            size += this.residualSizes[i];
        }
        return size;
    }

    public int getFrameSize(int frame) {
        return this.residualSizes[frame];
    }
}

