/*
 * Decompiled with CFR 0.152.
 */
package MGP_I15;

import MGP_I15.MaryTTS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Server {
    public static void main(String[] args) {
        new Server().startServer();
    }

    public void startServer() {
        final ExecutorService clientProcessingPool = Executors.newFixedThreadPool(10);
        Runnable serverTask = new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(8000);
                    System.out.println("Waiting for clients to connect...");
                    while (true) {
                        Socket clientSocket = serverSocket.accept();
                        clientProcessingPool.submit(new ClientTask(clientSocket));
                    }
                }
                catch (IOException e) {
                    System.err.println("Unable to process client request");
                    e.printStackTrace();
                    return;
                }
            }
        };
        Thread serverThread = new Thread(serverTask);
        serverThread.start();
    }

    private class ClientTask
    implements Runnable {
        private final Socket clientSocket;

        private ClientTask(Socket clientSocket) {
            this.clientSocket = clientSocket;
        }

        @Override
        public void run() {
            System.out.println("Got a client !");
            try {
                String[] args;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                StringBuilder sb = new StringBuilder();
                String line = "";
                while (br.ready() && (line = br.readLine()) != null) {
                    sb.append(String.valueOf(line) + "\r\n");
                }
                String result = sb.toString();
                System.out.println("Received args : " + result);
                if (result.contains("-p")) {
                    String[] tempArgs = result.split("\"");
                    args = new String[tempArgs.length];
                    int i = 0;
                    while (i < tempArgs.length) {
                        args[i] = tempArgs[i].trim();
                        ++i;
                    }
                } else {
                    args = result.split(" ");
                }
                args[args.length - 1] = args[args.length - 1].trim();
                MaryTTS.MaryPlay(args);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                this.clientSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

