#include <iostream>
#include <stdio.h>
#include <termio.h>
#include <unistd.h>
#include <dynamixel.h>
#include <math.h>
#include <stdio.h> // standard input / output functions
#include <string.h> // string function definitions
#include <unistd.h> // UNIX standard function definitions
#include <fcntl.h> // File control definitions
#include <stdlib.h>
#include <iostream>
#include <SerialStream.h>
#include <fcntl.h>
#include <cstdlib>
//
using namespace LibSerial ;
using namespace std;

#define L		5

// Control table address
#define P_GOAL_POSITION_L		30
#define P_GOAL_POSITION_H		31
#define P_MOVING_SPEED_L		32
#define P_MOVING_SPEED_H		33
#define P_PRESENT_POSITION_L	36
#define P_PRESENT_POSITION_H	37
#define P_PRESENT_SPEED_L		38
#define P_PRESENT_SPEED_H		39
#define P_MOVING				46

//zero value
#define ZERO_SERVO1		2450
#define ZERO_SERVO2		1600
#define ZERO_SERVO3		305
#define ZERO_SERVO4		440
#define ZERO_SERVO5		515
#define ZERO_SERVO6		1800

int *val_now;
bool init;

// An object can be the object to displace or an obstacle
struct OBJECT {
    double x; // x position for the center of the object
    double y; // y position for the center of the object
    double z; // z position for the center of the object
    double height; // height of the object
    double radius; // radius or width of the object
};

/*----------Maple mini Communication----------*/

int open_port(const char *portName)
{
	int fd; // file description for the serial port
	const char *str = "/dev/";
	char path[20];
	strcpy(path,str);
    strcat(path, portName);
	fd = open(path, O_RDWR | O_NOCTTY | O_NDELAY);

	if(fd == -1) // if open is unsucessful
	{
		//cout << "open_port: Unable to open " << path << endl;
	}
	else
	{
		fcntl(fd, F_SETFL, 0);
	}

	return(fd);
}

int configure_port(int fd)      // configure the port
{
	struct termios port_settings;      // structure to store the port settings in

	cfsetispeed(&port_settings, B115200);    // set baud rates
	cfsetospeed(&port_settings, B115200);

	port_settings.c_cflag &= ~PARENB;    // set no parity, stop bits, data bits
	port_settings.c_cflag &= ~CSTOPB;
	port_settings.c_cflag &= ~CSIZE;
	port_settings.c_cflag |= CS8;

	tcsetattr(fd, TCSANOW, &port_settings);    // apply the settings to the port
	return(fd);

} //configure_port

//Send an input to the maple_mini
int query2maple(int fd, unsigned char send_bytes[])
{
    cout << strlen((char*)send_bytes) << endl;
	write(fd, send_bytes, strlen((char*)send_bytes));

	return 0;

}


char change_hand_state(const char *portName)
{
    SerialStream serial_port ;
    char c;
    serial_port.Open(portName) ;
    if ( ! serial_port.good() )
    {
        std::cerr << "[" << __FILE__ << ":" << __LINE__ << "] "
                  << "Error: Could not open serial port." << portName
                  << std::endl ;
        exit(1) ;
    }
    //
    // Set the baud rate of the serial port.
    //
    serial_port.SetBaudRate( SerialStreamBuf::BAUD_9600 ) ;
    if ( ! serial_port.good() )
    {
        std::cerr << "Error: Could not set the baud rate." <<  std::endl ;
        exit(1) ;
    }
    char output;
    char out_buf[] = "1";
    serial_port.write(out_buf, 1);  //<-- FIRST COMMAND
    while(1)
    {
        serial_port.get(output); // HERE I RECEIVE THE FIRST ANSWER
        break;
    }
    serial_port.Close();
    return output;
}
void open_hand(const char *portName)
{
    const char *str = "/dev/";
    char path[20];
    strcpy(path,str);
    strcat(path, portName);

    char output;
    output = change_hand_state(path);
    if (output != '0')
    {
        output = change_hand_state(path);
    }
}

void close_hand(const char *portName)
{
    const char *str = "/dev/";
    char path[20];
    strcpy(path,str);
    strcat(path, portName);

    char output;
    output = change_hand_state(path);
    if (output != '1')
    {
        output = change_hand_state(path);
    }

}

/*----------Dynamixel Communication----------*/

int * convert_servo_val(double * angle)
{
	static int val[3];
	double temp;
	//1st value in the angle array is alpha =>1st servo EX106
	temp = angle[0]*836.3632+ZERO_SERVO1;
	if (angle[0]<0)
		temp += 100*angle[0];
	else
		temp += 50*angle[0];
	val[0] = (int)temp;

	//2nd value in the angle array is beta =>4th servo RX64
	temp = -(3.1416-angle[1])*195.3786+ZERO_SERVO4 +10; //cablirage
	val[1] = (int)temp;

	//3rd value in the angle array is theta =>2nd servo EX106
	temp = -angle[2]*836.3632+ZERO_SERVO2 +10;//cablirage
	val[2] = (int)temp;

	return val;
}

int servo_6_cal(int servo_2, int servo_4)
{
	double servo_6;
	double servo_4_angle = (servo_4 - ZERO_SERVO4)/195.3786 + 3.1416;
	double servo_2_angle = (ZERO_SERVO2 - servo_2)/836.3632;
	servo_6 = 651.8971*(3.1416 - servo_2_angle - servo_4_angle) + ZERO_SERVO6;

	return (int)servo_6+30+300;
}

void movement(int *val, int type)
{
	//type 1 => initialization;
	//type 2 => move an object to the target position;
	//type 3 => take an object;
	//pour type 1: le bras va bouger à l'endroit qui est proche que le bon endroit, en puis il va prolonger un peu plus
	//pour type 2: la meme chose
	//pour éviter la collision avec la table, le servo 4 la ouvrir en 2 phases: 1ere phase: ouvrir à le point qui est = bon point - 300(servo 2 en plus haut) et puis le servo 2 va descendre en meme temp avec le servo 4.
	//calculer la postition ciblee du servo 6
	//type 3 : the arm will move to a position at the right of the wanting position and will move to the left. Like this, we will avoid colliding with the object;
	double pos_6 = servo_6_cal(1000,0);
	//Fermer et préparer le bras
	switch(type)
	{
	    case 1:
            pos_6 = 3600;
            dxl_write_word( 6, P_MOVING_SPEED_L,400);
            dxl_write_word( 6, P_GOAL_POSITION_L,pos_6);

            dxl_write_word( 2, P_GOAL_POSITION_L,1000);
            dxl_write_word( 4, P_GOAL_POSITION_L,0);
            dxl_write_word( 6, P_MOVING_SPEED_L,50);
            break;
        case 2:
        case 3:
            dxl_write_word( 2, P_GOAL_POSITION_L,1000);
            dxl_write_word( 4, P_GOAL_POSITION_L,0);
            dxl_write_word( 6, P_GOAL_POSITION_L,pos_6);
            usleep(500000);
            break;

	}
	//bouger le 1er servo
	if(type == 3)
    {
        dxl_write_word( 1, P_GOAL_POSITION_L,val[0] + 200);
    }
	else
    {
        dxl_write_word( 1, P_GOAL_POSITION_L,val[0]);
	}

	//phase 1: le servo 4 ouvre au bon endroit - 75, servo 5 tourner a droit un peu pour eviter de toucher l'objet
	pos_6 = servo_6_cal(1000,val[1]-150);
	dxl_write_word( 6, P_MOVING_SPEED_L,50);
	dxl_write_word( 6, P_GOAL_POSITION_L,pos_6);
	if (val[1]-75 <0)
		dxl_write_word( 4, P_GOAL_POSITION_L,0);
	else
		dxl_write_word( 4, P_GOAL_POSITION_L,val[1]-75);
	if (type ==1)
		dxl_write_word( 5, P_GOAL_POSITION_L,600);
	usleep(2000000);
	//finir phase 1

	//phase 2: aller à bon endroit
	pos_6 = servo_6_cal(val[2],val[1]);
	dxl_write_word( 6, P_MOVING_SPEED_L,400);
	dxl_write_word( 6, P_GOAL_POSITION_L,pos_6);
	dxl_write_word( 2, P_MOVING_SPEED_L,50);
	dxl_write_word( 2, P_GOAL_POSITION_L,val[2]);
	dxl_write_word( 4, P_MOVING_SPEED_L,50);
	dxl_write_word( 4, P_GOAL_POSITION_L,val[1]-30);
	if (type ==1)
	{
		dxl_write_word( 5, P_MOVING_SPEED_L,30);
		usleep(200000);
		dxl_write_word( 5, P_GOAL_POSITION_L,580);
		usleep(200000);
		dxl_write_word( 5, P_GOAL_POSITION_L,560);
		usleep(200000);
		dxl_write_word( 5, P_GOAL_POSITION_L,550);
	}
	dxl_write_word( 4, P_MOVING_SPEED_L,30);
	usleep(200000);
	dxl_write_word( 4, P_GOAL_POSITION_L,val[1]-20);
	usleep(200000);
	dxl_write_word( 4, P_GOAL_POSITION_L,val[1]-10);
	usleep(200000);
	dxl_write_word( 4, P_GOAL_POSITION_L,val[1]);
	dxl_write_word( 2, P_MOVING_SPEED_L,50);
	dxl_write_word( 4, P_MOVING_SPEED_L,100);
	usleep(500000);

    if(type == 3)
    {
    dxl_write_word( 1, P_MOVING_SPEED_L,30);
    usleep(200000);
    dxl_write_word( 1, P_GOAL_POSITION_L,val[0]);
    usleep(1000000);
    dxl_write_word( 1, P_MOVING_SPEED_L,100);
    }
	val_now = val;
}

void initialization()
{
    dxl_write_word( 1, P_MOVING_SPEED_L,200);
    dxl_write_word( 2, P_MOVING_SPEED_L,200);
    dxl_write_word( 3, P_MOVING_SPEED_L,200);
    dxl_write_word( 4, P_MOVING_SPEED_L,200);
    dxl_write_word( 5, P_MOVING_SPEED_L,200);
    dxl_write_word( 6, P_MOVING_SPEED_L,400);



    dxl_write_word( 2, P_GOAL_POSITION_L,1000);
    while(dxl_read_byte( 2, P_MOVING )==1)
    {
        printf("Servo 2 est en train de bouger");
    }

    dxl_write_word( 6, P_GOAL_POSITION_L,3600);

    dxl_write_word( 5, P_GOAL_POSITION_L,ZERO_SERVO5);
    dxl_write_word( 3, P_GOAL_POSITION_L,ZERO_SERVO3);
    dxl_write_word( 4, P_GOAL_POSITION_L,0);
    while(dxl_read_byte( 5, P_MOVING )==1)
    {
        printf("Servo 5 est en train de bouger");
    }

    while(dxl_read_byte( 3, P_MOVING )==1)
    {
        printf("Servo 3 est en train de bouger");
    }

    while(dxl_read_byte( 4, P_MOVING )==1)
    {
        printf("Servo 4 est en train de bouger");
    }

    dxl_write_word( 1, P_GOAL_POSITION_L,1000);
    while(dxl_read_byte( 1, P_MOVING )==1)
    {
        printf("Servo 1 est en train de bouger");
    }

    //changer la vitesse
    dxl_write_word( 1, P_MOVING_SPEED_L,100);
    dxl_write_word( 2, P_MOVING_SPEED_L,100);
    dxl_write_word( 4, P_MOVING_SPEED_L,100);
    dxl_write_word( 6, P_MOVING_SPEED_L,50);
    init = true;

    static int val[3];
    val[0] = 1000;
    val[1] = 0;
    val[2] = 1000;
    val_now = (int *)val;

}

/*---------- Distance operations ----------*/

// return the angles values (in rad) for the 3 servomotors used for moving the arm
double * IK(double x, double y, double h, double l1, double l2, double taille)
{
	// la taille correspond au rayon de l'objet
	static double angle[3];
	double alpha;
	double longeur_bis;
	double l_prim;
	double longeur;
	double a2;
	//modifier les coordonnees
	longeur = sqrt(x*x + y*y);
	alpha = asin(taille/longeur);// alpha correspond a l'ecart de l'angle tel que la main sera sur le cote de l'objet
	longeur_bis = sqrt(longeur*longeur-taille*taille)-L-2.5; // Nouvelle longueur tel que le centre de la main soit sur le cote de l'objet
	if (y == 0)
		if (x > 0)
			angle[0] = 1.5708;
		else
			angle[0] = -1.5708;
	else
		angle[0] = atan(x/y);
	angle[0] += alpha;

	//calculer les angles
	l_prim = sqrt(h*h + longeur_bis*longeur_bis);
	if (longeur == 0)
		a2 = 1.5708;
	else
		a2 = atan(h/longeur_bis);
	angle[2] = acos((l1*l1 + l_prim*l_prim-l2*l2)/(2*l1*l_prim)) - a2;
	angle[1] = acos((l1*l1 + l2*l2 - l_prim*l_prim)/(2*l1*l2));
	return angle;
}

bool check_values(double x, double y, double h, double radius, double l1, double l2)
{
    //y ne peut pas etre negative
    if (y<8.8)
    {
        fprintf(stderr, "y value must be more than 8.8cm/n");
        return false;
    }

    double longeur = sqrt(x*x+y*y);
    double longeur_bis = sqrt(longeur*longeur-radius*radius)-L-2.5;

    if (longeur_bis > sqrt ((l1+l2)*(l1+l2) - h*h))
    {
        fprintf(stderr, "The position can't be reach because values are too big\n");
        return false;
    }

    double* angle_init = IK(x, y, h, l1, l2, radius);
    if ((angle_init[2] > (ZERO_SERVO2-1000)/836.3632) || (angle_init[1] < -ZERO_SERVO4/195.3786+3.1416))
    {
        fprintf(stderr, "The position can't be reach because values are too short\n");
        return false;
    }

    return true;
}

//Determine if there is an obstacle
bool check_obstacles(double x, double y, double h, double radius, OBJECT obstacles[])
{
    return true;
}

void simple_move_object(OBJECT target, OBJECT obstacles[], double ceiling_height, double new_x, double new_y)
{

}

int main()
{
    char again;
    int *val;
    double *angle;
    const char *maplePortName = "ttyACM0";
    //initial values for test
    double height = 23;
    double radius_object = 3.5;
    double l1 = 26.3;
    double l2 = 25.4;
    double x_object;// = -30;
    double y_object;// = 30;
    double x_target;// = 30;
    double y_target;// = 30;
    double ceiling_height = 30;

    int baudnum = 1;
    int deviceIndex = 0;

    fprintf(stderr, "\n\n=============== Arm control for Linux =================\n\n" );
    ///////// Open USB2Dynamixel ////////////
    if( dxl_initialize(deviceIndex, baudnum) == 0 )
    {
            fprintf(stderr, "Failed to open USB2Dynamixel!\n" );
       		fprintf(stderr, "Press Enter key to terminate...\n" );
            getchar();
            return 0;
    }
    else
            fprintf(stderr, "Succeed to open USB2Dynamixel!\n" );

    fprintf(stderr, "\n==================== Initialization ======================\n\n");

    initialization();
    open_hand(maplePortName);
    fprintf(stderr, "Initialisation done\n");
    sleep(3);

    fprintf(stderr, "\n======================= Movement =========================\n\n");

    while(true)
    {
        bool correctPosition = false;
        while(!correctPosition)
        {
            cout << "please enter x initial value" << endl;
            cin >>  x_object;
            cout << "please enter y initial value" << endl;
            cin >>  y_object;
            cout << "please enter x target value" << endl;
            cin >>  x_target;
            cout << "please enter y target value" << endl;
            cin >>  y_target;
            correctPosition = check_values(x_object, y_object, height, radius_object, l1, l2);
            if (!check_values(x_target, y_target, height, radius_object, l1, l2))
            {
                correctPosition = false;
            }

            //cout << "The configuration is : \n    x = " << x_object << "\n    y = " << y_object << "\n    height = " << height << "\n    radius = " << radius_object << "\n    l1 = " << l1 << "\n    l2 = " << l2 << endl;
        }
        angle = IK(x_object, y_object, height, l1, l2, radius_object);
        val = convert_servo_val(angle);
        //We move the arm to the selected position
        movement(val,3);
        sleep(2);
        close_hand(maplePortName);
        sleep(2);
        angle = IK(x_target, y_target, height, l1, l2, radius_object);
        val = convert_servo_val(angle);
        movement(val,2);
        sleep(2);
        open_hand(maplePortName);
        usleep(1000000);
        dxl_write_word( 1, P_MOVING_SPEED_L,30);
        usleep(200000);
        dxl_write_word( 1, P_GOAL_POSITION_L,val[0]+200);
        usleep(1000000);
        dxl_write_word( 1, P_MOVING_SPEED_L,100);
        cout << "Do you want to continue ? y/n" << endl;
        cin >> again;

        if (again != 'y')
        {
            break;
    fprintf(stderr, "\n========================= END ===========================\n\n");
        }
    }
}
